/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.jersey;

import com.intuit.karate.ScriptContext;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.http.Cookie;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpConfig;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.http.MultiValuedMap;
import com.intuit.karate.http.jersey.LoggingInterceptor;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;

public class JerseyHttpClient
extends HttpClient<Entity> {
    private Client client;
    private WebTarget target;
    private Invocation.Builder builder;

    public void configure(HttpConfig config, ScriptContext context) {
        ClientConfig cc = new ClientConfig();
        cc.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        if (!config.isFollowRedirects()) {
            cc.property("jersey.config.client.followRedirects", (Object)false);
        }
        ClientBuilder clientBuilder = (ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().withConfig((Configuration)cc).register((Object)new LoggingInterceptor(context))).register(MultiPartFeature.class);
        if (config.isSslEnabled()) {
            String sslAlgorithm = config.getSslAlgorithm();
            SSLContext ssl = HttpUtils.getSslContext((String)sslAlgorithm);
            HttpsURLConnection.setDefaultSSLSocketFactory(ssl.getSocketFactory());
            clientBuilder.sslContext(ssl);
            clientBuilder.hostnameVerifier((host, session) -> true);
        }
        this.client = clientBuilder.build();
        this.client.property("jersey.config.client.connectTimeout", (Object)config.getConnectTimeout());
        this.client.property("jersey.config.client.readTimeout", (Object)config.getReadTimeout());
        if (config.getProxyUri() != null) {
            this.client.property("jersey.config.client.proxy.uri", (Object)config.getProxyUri());
            if (config.getProxyUsername() != null && config.getProxyPassword() != null) {
                this.client.property("jersey.config.client.proxy.username", (Object)config.getProxyUsername());
                this.client.property("jersey.config.client.proxy.password", (Object)config.getProxyPassword());
            }
        }
    }

    public String getRequestUri() {
        return this.target.getUri().toString();
    }

    public void buildUrl(String url) {
        this.target = this.client.target(url);
        this.builder = this.target.request();
    }

    public void buildPath(String path) {
        this.target = this.target.path(path);
        this.builder = this.target.request();
    }

    public void buildParam(String name, Object ... values) {
        this.target = this.target.queryParam(name, values);
        this.builder = this.target.request();
    }

    public void buildHeader(String name, Object value, boolean replace) {
        if (replace) {
            this.builder.header(name, null);
        }
        this.builder.header(name, value);
    }

    public void buildCookie(Cookie c) {
        javax.ws.rs.core.Cookie cookie = new javax.ws.rs.core.Cookie(c.getName(), c.getValue());
        this.builder.cookie(cookie);
    }

    public Entity getEntity(MultiValuedMap fields, String mediaType) {
        MultivaluedHashMap map = new MultivaluedHashMap();
        for (Map.Entry entry : fields.entrySet()) {
            map.put(entry.getKey(), (List)entry.getValue());
        }
        return Entity.entity((Object)map, (String)mediaType);
    }

    public Entity getEntity(List<MultiPartItem> items, String mediaType) {
        MultiPart multiPart = new MultiPart();
        for (MultiPartItem item : items) {
            if (item.getValue() == null || item.getValue().isNull()) continue;
            String name = item.getName();
            String filename = item.getFilename();
            ScriptValue sv = item.getValue();
            String ct = item.getContentType();
            if (ct == null) {
                ct = HttpUtils.getContentType((ScriptValue)sv);
            }
            MediaType itemType = MediaType.valueOf((String)ct);
            if (name == null) {
                BodyPart bp = new BodyPart().entity((Object)sv.getAsString()).type(itemType);
                multiPart.bodyPart(bp);
                continue;
            }
            if (filename != null) {
                StreamDataBodyPart part = new StreamDataBodyPart(name, sv.getAsStream(), filename, itemType);
                multiPart.bodyPart((BodyPart)part);
                continue;
            }
            multiPart.bodyPart((BodyPart)new FormDataBodyPart(name, (Object)sv.getAsString(), itemType));
        }
        return Entity.entity((Object)multiPart, (String)mediaType);
    }

    public Entity getEntity(String value, String mediaType) {
        return Entity.entity((Object)value, (String)mediaType);
    }

    public Entity getEntity(InputStream value, String mediaType) {
        return Entity.entity((Object)value, (String)mediaType);
    }

    public HttpResponse makeHttpRequest(Entity entity, long startTime) {
        String method = this.request.getMethod();
        if ("PATCH".equals(method)) {
            this.builder.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        }
        Response resp = entity != null ? this.builder.method(method, entity) : this.builder.method(method);
        byte[] bytes = (byte[])resp.readEntity(byte[].class);
        long responseTime = JerseyHttpClient.getResponseTime((long)startTime);
        HttpResponse response = new HttpResponse(responseTime);
        response.setUri(this.getRequestUri());
        response.setBody(bytes);
        response.setStatus(resp.getStatus());
        for (NewCookie c : resp.getCookies().values()) {
            Cookie cookie = new Cookie(c.getName(), c.getValue());
            cookie.put((Object)"domain", (Object)c.getDomain());
            cookie.put((Object)"path", (Object)c.getPath());
            if (c.getExpiry() != null) {
                cookie.put((Object)"expires", (Object)(c.getExpiry().getTime() + ""));
            }
            cookie.put((Object)"secure", (Object)(c.isSecure() + ""));
            cookie.put((Object)"http-only", (Object)(c.isHttpOnly() + ""));
            cookie.put((Object)"max-age", (Object)(c.getMaxAge() + ""));
            response.addCookie(cookie);
        }
        for (Map.Entry entry : resp.getHeaders().entrySet()) {
            response.putHeader((String)entry.getKey(), (List)entry.getValue());
        }
        return response;
    }
}

