/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.jersey;

import com.intuit.karate.FileUtils;
import com.intuit.karate.ScenarioContext;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.LoggingFilterOutputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public class LoggingInterceptor
implements ClientRequestFilter,
ClientResponseFilter {
    private final ScenarioContext context;
    private final AtomicInteger counter = new AtomicInteger();
    private long startTime;

    public LoggingInterceptor(ScenarioContext context) {
        this.context = context;
    }

    private static boolean isPrintable(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        return HttpUtils.isPrintable((String)mediaType.toString());
    }

    private static void logHeaders(StringBuilder sb, int id, char prefix, MultivaluedMap<String, String> headers, HttpRequest actual) {
        TreeSet keys = new TreeSet(headers.keySet());
        for (String key : keys) {
            List entries = (List)headers.get((Object)key);
            sb.append(id).append(' ').append(prefix).append(' ').append(key).append(": ").append(entries.size() == 1 ? entries.get(0) : entries).append('\n');
            if (actual == null) continue;
            actual.putHeader(key, entries);
        }
    }

    public void filter(ClientRequestContext request) throws IOException {
        if (request.hasEntity() && LoggingInterceptor.isPrintable(request.getMediaType())) {
            LoggingFilterOutputStream out = new LoggingFilterOutputStream(request.getEntityStream());
            request.setEntityStream((OutputStream)out);
            request.setProperty(LoggingFilterOutputStream.KEY, (Object)out);
        }
        this.startTime = System.currentTimeMillis();
    }

    public void filter(ClientRequestContext request, ClientResponseContext response) throws IOException {
        String buffer;
        long endTime = System.currentTimeMillis();
        long responseTime = endTime - this.startTime;
        HttpRequest actual = new HttpRequest();
        this.context.setPrevRequest(actual);
        actual.setStartTime(this.startTime);
        actual.setEndTime(endTime);
        int id = this.counter.incrementAndGet();
        String method = request.getMethod();
        String uri = request.getUri().toASCIIString();
        actual.setMethod(method);
        actual.setUri(uri);
        StringBuilder sb = new StringBuilder();
        sb.append("request\n").append(id).append(" > ").append(method).append(' ').append(uri).append('\n');
        LoggingInterceptor.logHeaders(sb, id, '>', (MultivaluedMap<String, String>)request.getStringHeaders(), actual);
        LoggingFilterOutputStream out = (LoggingFilterOutputStream)request.getProperty(LoggingFilterOutputStream.KEY);
        if (out != null) {
            byte[] bytes = out.getBytes().toByteArray();
            actual.setBody(bytes);
            buffer = FileUtils.toString((byte[])bytes);
            if (this.context.getConfig().isLogPrettyRequest()) {
                buffer = FileUtils.toPrettyString((String)buffer);
            }
            sb.append(buffer).append('\n');
        }
        this.context.logger.debug(sb.toString(), new Object[0]);
        sb = new StringBuilder();
        sb.append("response time in milliseconds: ").append(responseTime).append('\n');
        sb.append(id).append(" < ").append(response.getStatus()).append('\n');
        LoggingInterceptor.logHeaders(sb, id, '<', (MultivaluedMap<String, String>)response.getHeaders(), null);
        if (response.hasEntity() && LoggingInterceptor.isPrintable(response.getMediaType())) {
            InputStream is = response.getEntityStream();
            if (!is.markSupported()) {
                is = new BufferedInputStream(is);
            }
            is.mark(Integer.MAX_VALUE);
            buffer = FileUtils.toString((InputStream)is);
            if (this.context.getConfig().isLogPrettyResponse()) {
                buffer = FileUtils.toPrettyString((String)buffer);
            }
            sb.append(buffer).append('\n');
            is.reset();
            response.setEntityStream(is);
        }
        this.context.logger.debug(sb.toString(), new Object[0]);
    }
}

