/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.jersey;

import com.intuit.karate.FileUtils;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.http.HttpLogModifier;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.LoggingFilterOutputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public class LoggingInterceptor
implements ClientRequestFilter,
ClientResponseFilter {
    private final ScenarioContext context;
    private final HttpLogModifier logModifier;
    private final AtomicInteger counter = new AtomicInteger();

    public LoggingInterceptor(ScenarioContext context) {
        this.context = context;
        this.logModifier = context.getConfig().getLogModifier();
    }

    private static boolean isPrintable(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        return HttpUtils.isPrintable((String)mediaType.toString());
    }

    private static void logHeaders(HttpLogModifier logModifier, StringBuilder sb, int id, char prefix, MultivaluedMap<String, String> headers, HttpRequest actual) {
        TreeSet keys = new TreeSet(headers.keySet());
        for (String key : keys) {
            List entries = (List)headers.get((Object)key);
            sb.append(id).append(' ').append(prefix).append(' ').append(key).append(": ");
            if (entries.size() == 1) {
                String entry = (String)entries.get(0);
                if (logModifier != null) {
                    entry = logModifier.header(key, entry);
                }
                sb.append(entry).append('\n');
            } else if (logModifier == null) {
                sb.append(entries).append('\n');
            } else {
                ArrayList<String> list = new ArrayList<String>(entries.size());
                for (String entry : entries) {
                    list.add(logModifier.header(key, entry));
                }
                sb.append(list).append('\n');
            }
            if (actual == null) continue;
            actual.putHeader(key, entries);
        }
    }

    public void filter(ClientRequestContext request) throws IOException {
        if (request.hasEntity() && LoggingInterceptor.isPrintable(request.getMediaType())) {
            LoggingFilterOutputStream out = new LoggingFilterOutputStream(request.getEntityStream());
            request.setEntityStream((OutputStream)out);
            request.setProperty(LoggingFilterOutputStream.KEY, (Object)out);
        }
        HttpRequest actual = new HttpRequest();
        this.context.setPrevRequest(actual);
        actual.startTimer();
    }

    public void filter(ClientRequestContext request, ClientResponseContext response) throws IOException {
        boolean showLog;
        HttpRequest actual = this.context.getPrevRequest();
        actual.stopTimer();
        int id = this.counter.incrementAndGet();
        String method = request.getMethod();
        String uri = request.getUri().toASCIIString();
        actual.setMethod(method);
        actual.setUri(uri);
        boolean bl = showLog = !this.context.isReportDisabled() && this.context.getConfig().isShowLog();
        if (!showLog) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        HttpLogModifier requestModifier = this.logModifier == null ? null : (this.logModifier.enableForUri(uri) ? this.logModifier : null);
        String maskedUri = requestModifier == null ? uri : requestModifier.uri(uri);
        sb.append("request\n").append(id).append(" > ").append(method).append(' ').append(maskedUri).append('\n');
        LoggingInterceptor.logHeaders(requestModifier, sb, id, '>', (MultivaluedMap<String, String>)request.getStringHeaders(), actual);
        LoggingFilterOutputStream out = (LoggingFilterOutputStream)request.getProperty(LoggingFilterOutputStream.KEY);
        if (out != null) {
            byte[] bytes = out.getBytes().toByteArray();
            actual.setBody(bytes);
            String buffer = FileUtils.toString((byte[])bytes);
            if (this.context.getConfig().isLogPrettyRequest()) {
                buffer = FileUtils.toPrettyString((String)buffer);
            }
            if (requestModifier != null) {
                buffer = requestModifier.request(uri, buffer);
            }
            sb.append(buffer).append('\n');
        }
        this.context.logger.debug(sb.toString(), new Object[0]);
        sb = new StringBuilder();
        sb.append("response time in milliseconds: ").append(actual.getResponseTimeFormatted()).append('\n');
        sb.append(id).append(" < ").append(response.getStatus()).append('\n');
        LoggingInterceptor.logHeaders(requestModifier, sb, id, '<', (MultivaluedMap<String, String>)response.getHeaders(), null);
        if (response.hasEntity() && LoggingInterceptor.isPrintable(response.getMediaType())) {
            InputStream is = response.getEntityStream();
            String contentEncoding = (String)response.getHeaders().getFirst((Object)"Content-Encoding");
            if (contentEncoding != null && "gzip".equalsIgnoreCase(contentEncoding)) {
                is = new GZIPInputStream(is);
            }
            if (!is.markSupported()) {
                is = new BufferedInputStream(is);
            }
            is.mark(Integer.MAX_VALUE);
            String buffer = FileUtils.toString((InputStream)is);
            if (this.context.getConfig().isLogPrettyResponse()) {
                buffer = FileUtils.toPrettyString((String)buffer);
            }
            if (requestModifier != null) {
                buffer = requestModifier.request(uri, buffer);
            }
            sb.append(buffer).append('\n');
            if (is.markSupported()) {
                is.reset();
            }
            response.setEntityStream(is);
        }
        this.context.logger.debug(sb.toString(), new Object[0]);
    }
}

