/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit4;

import com.intuit.karate.cucumber.CucumberRunner;
import com.intuit.karate.junit4.KarateFeatureRunner;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.junit.FeatureRunner;
import cucumber.runtime.junit.JUnitOptions;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Karate
extends ParentRunner<KarateFeatureRunner> {
    private static final Logger logger = LoggerFactory.getLogger(Karate.class);
    private final JUnitReporter reporter;
    private final List<KarateFeatureRunner> children;

    public Karate(Class clazz) throws InitializationError, IOException {
        super(clazz);
        CucumberRunner cr = new CucumberRunner(clazz);
        RuntimeOptions ro = cr.getRuntimeOptions();
        List cucumberFeatures = cr.getFeatures();
        ClassLoader cl = cr.getClassLoader();
        JUnitOptions junitOptions = new JUnitOptions(ro.getJunitOptions());
        this.reporter = new JUnitReporter(ro.reporter(cl), ro.formatter(cl), ro.isStrict(), junitOptions);
        this.children = new ArrayList<KarateFeatureRunner>(cucumberFeatures.size());
        for (CucumberFeature feature : cucumberFeatures) {
            Runtime runtime = cr.getRuntime(feature);
            FeatureRunner runner = new FeatureRunner(feature, runtime, this.reporter);
            this.children.add(new KarateFeatureRunner(runner, runtime));
        }
    }

    public List<KarateFeatureRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(KarateFeatureRunner child) {
        return child.runner.getDescription();
    }

    protected void runChild(KarateFeatureRunner child, RunNotifier notifier) {
        child.runner.run(notifier);
        child.runtime.printSummary();
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        this.reporter.done();
        this.reporter.close();
    }
}

