/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit4;

import com.intuit.karate.CallContext;
import com.intuit.karate.cucumber.DummyFormatter;
import com.intuit.karate.cucumber.DummyReporter;
import com.intuit.karate.cucumber.KarateFeature;
import com.intuit.karate.cucumber.KarateHtmlReporter;
import com.intuit.karate.cucumber.KarateReporter;
import com.intuit.karate.cucumber.KarateRuntime;
import com.intuit.karate.cucumber.KarateRuntimeOptions;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.junit.FeatureRunner;
import cucumber.runtime.junit.JUnitOptions;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberFeature;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class Karate
extends ParentRunner<KarateFeature> {
    private final List<KarateFeature> children;
    private final Map<String, Description> descriptions;
    private JUnitReporter reporter;
    private KarateHtmlReporter htmlReporter;

    public Karate(Class clazz) throws InitializationError, IOException {
        super(clazz);
        List testMethods = this.getTestClass().getAnnotatedMethods(Test.class);
        if (!testMethods.isEmpty()) {
            System.err.println("WARNING: there are methods annotated with '@Test', they will NOT be run when using '@RunWith(Karate.class)'");
        }
        KarateRuntimeOptions kro = new KarateRuntimeOptions(clazz);
        this.children = KarateFeature.loadFeatures((KarateRuntimeOptions)kro);
        this.descriptions = new HashMap<String, Description>(this.children.size());
    }

    public List<KarateFeature> getChildren() {
        return this.children;
    }

    protected Description describeChild(KarateFeature child) {
        Description description = this.descriptions.get(child.getFeature().getPath());
        if (description != null) {
            return description;
        }
        Feature feature = child.getFeature().getGherkinFeature();
        String name = feature.getKeyword() + ": " + feature.getName();
        return Description.createSuiteDescription((String)name, (Serializable)feature, (Annotation[])new Annotation[0]);
    }

    private void initReporters() {
        KarateRuntimeOptions kro = new KarateRuntimeOptions(this.getTestClass().getJavaClass());
        RuntimeOptions ro = kro.getRuntimeOptions();
        JUnitOptions junitOptions = new JUnitOptions(ro.getJunitOptions());
        this.htmlReporter = new KarateHtmlReporter((Reporter)new DummyReporter(), (Formatter)new DummyFormatter());
        this.reporter = new JUnitReporter((Reporter)this.htmlReporter, (Formatter)this.htmlReporter, ro.isStrict(), junitOptions){
            final List<Step> steps;
            final List<Match> matches;
            {
                this.steps = new ArrayList<Step>();
                this.matches = new ArrayList<Match>();
            }

            public void startOfScenarioLifeCycle(Scenario scenario) {
                this.steps.clear();
                this.matches.clear();
                super.startOfScenarioLifeCycle(scenario);
            }

            public void step(Step step) {
                this.steps.add(step);
            }

            public void match(Match match) {
                this.matches.add(match);
            }

            public void result(Result result) {
                Step step = this.steps.remove(0);
                Match match = this.matches.remove(0);
                CallContext callContext = new CallContext(null, 0, null, -1, false, false, null);
                Karate.this.htmlReporter.karateStep(step, match, result, callContext);
                super.step(step);
                super.match(match);
                super.result(result);
            }

            public void eof() {
                try {
                    super.eof();
                }
                catch (Exception e) {
                    System.err.println("WARNING: cucumber native plugin / formatter failed: " + e.getMessage());
                }
            }
        };
    }

    protected void runChild(KarateFeature child, RunNotifier notifier) {
        FeatureRunner runner;
        if (this.reporter == null) {
            this.initReporters();
        }
        KarateRuntime runtime = child.getRuntime((KarateReporter)this.htmlReporter);
        CucumberFeature feature = child.getFeature();
        try {
            runner = new FeatureRunner(feature, (Runtime)runtime, this.reporter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.htmlReporter.startKarateFeature(feature);
        runner.run(notifier);
        runtime.afterFeature();
        runtime.printSummary();
        this.htmlReporter.endKarateFeature();
        this.descriptions.put(feature.getPath(), runner.getDescription());
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        if (this.reporter != null) {
            this.reporter.done();
            this.reporter.close();
        }
    }
}

