/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit4;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Resource;
import com.intuit.karate.RunnerOptions;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureParser;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.Tags;
import com.intuit.karate.junit4.FeatureInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Karate
extends ParentRunner<Feature> {
    private static final Logger logger = LoggerFactory.getLogger(Karate.class);
    private final List<Feature> children;
    private final Map<String, FeatureInfo> featureMap;
    private final String tagSelector;
    private static final Statement NO_OP = new Statement(){

        public void evaluate() throws Throwable {
        }
    };
    private boolean beforeClassDone;

    public Karate(Class<?> clazz) throws InitializationError, IOException {
        super(clazz);
        List testMethods = this.getTestClass().getAnnotatedMethods(Test.class);
        if (!testMethods.isEmpty()) {
            logger.warn("WARNING: there are methods annotated with '@Test', they will NOT be run when using '@RunWith(Karate.class)'");
        }
        RunnerOptions options = RunnerOptions.fromAnnotationAndSystemProperties(clazz);
        List resources = FileUtils.scanForFeatureFiles((List)options.getFeatures(), (ClassLoader)clazz.getClassLoader());
        this.children = new ArrayList<Feature>(resources.size());
        this.featureMap = new HashMap<String, FeatureInfo>(resources.size());
        for (Resource resource : resources) {
            Feature feature = FeatureParser.parse((Resource)resource);
            feature.setCallName(options.getName());
            feature.setCallLine(resource.getLine());
            this.children.add(feature);
        }
        this.tagSelector = Tags.fromKarateOptionsTags((List)options.getTags());
    }

    public List<Feature> getChildren() {
        return this.children;
    }

    protected Statement withBeforeClasses(Statement statement) {
        if (!this.beforeClassDone) {
            return super.withBeforeClasses(statement);
        }
        return statement;
    }

    protected Description describeChild(Feature feature) {
        if (!this.beforeClassDone) {
            try {
                Statement statement = this.withBeforeClasses(NO_OP);
                statement.evaluate();
                this.beforeClassDone = true;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        FeatureInfo info = new FeatureInfo(feature, this.tagSelector);
        this.featureMap.put(feature.getRelativePath(), info);
        return info.description;
    }

    protected void runChild(Feature feature, RunNotifier notifier) {
        FeatureInfo info = this.featureMap.get(feature.getRelativePath());
        info.setNotifier(notifier);
        info.unit.run();
        FeatureResult result = info.exec.result;
        result.printStats(null);
        Engine.saveResultHtml((String)(FileUtils.getBuildDir() + File.separator + "surefire-reports"), (FeatureResult)result, null);
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
    }
}

