/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit4;

import com.intuit.karate.RuntimeHook;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioRuntime;
import java.lang.annotation.Annotation;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JunitHook
implements RuntimeHook {
    private RunNotifier notifier;

    public void setNotifier(RunNotifier notifier) {
        this.notifier = notifier;
    }

    private static Description getScenarioDescription(Scenario scenario) {
        return Description.createTestDescription((String)scenario.getFeature().getNameForReport(), (String)scenario.getRefIdAndName(), (Annotation[])new Annotation[0]);
    }

    public boolean beforeScenario(ScenarioRuntime sr) {
        if (this.notifier == null || sr.caller.depth > 0) {
            return true;
        }
        this.notifier.fireTestStarted(JunitHook.getScenarioDescription(sr.scenario));
        return true;
    }

    public void afterScenario(ScenarioRuntime sr) {
        if (this.notifier == null || sr.caller.depth > 0) {
            return;
        }
        Description scenarioDescription = JunitHook.getScenarioDescription(sr.scenario);
        if (sr.isFailed()) {
            this.notifier.fireTestFailure(new Failure(scenarioDescription, sr.result.getError()));
        }
        this.notifier.fireTestFinished(scenarioDescription);
    }
}

