/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit4;

import com.intuit.karate.Runner;
import com.intuit.karate.RuntimeHook;
import com.intuit.karate.Suite;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.junit4.JunitHook;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Karate
extends ParentRunner<Feature> {
    private static final Logger logger = LoggerFactory.getLogger(Karate.class);
    private final Class annotatedClass;
    private final JunitHook hook;
    private final List<Feature> features;
    private Suite suite;

    public Karate(Class<?> clazz) throws InitializationError, IOException {
        super(clazz);
        this.annotatedClass = clazz;
        List testMethods = this.getTestClass().getAnnotatedMethods(Test.class);
        if (!testMethods.isEmpty()) {
            logger.warn("WARNING: there are methods annotated with '@Test', they will NOT be run when using '@RunWith(Karate.class)'");
        }
        this.hook = new JunitHook();
        Runner.Builder rb = Runner.builder().fromKarateAnnotation(clazz);
        this.features = rb.resolveAll();
    }

    protected Statement withBeforeClasses(final Statement statement) {
        List befores = this.getTestClass().getAnnotatedMethods(BeforeClass.class);
        Statement main = new Statement(){

            public void evaluate() throws Throwable {
                Runner.Builder rb = Runner.builder().fromKarateAnnotation(Karate.this.annotatedClass);
                rb.hook((RuntimeHook)Karate.this.hook);
                rb.features((Collection)Karate.this.features);
                Karate.this.suite = new Suite(rb);
                statement.evaluate();
            }
        };
        return befores.isEmpty() ? main : new RunBefores(main, befores, null);
    }

    public List<Feature> getChildren() {
        return this.features;
    }

    protected Description describeChild(Feature feature) {
        return Description.createSuiteDescription((String)feature.getNameForReport(), (Serializable)((Object)feature.getResource().getPackageQualifiedName()), (Annotation[])new Annotation[0]);
    }

    protected void runChild(Feature feature, RunNotifier notifier) {
        this.hook.setNotifier(notifier);
        FeatureRuntime fr = FeatureRuntime.of((Suite)this.suite, (Feature)feature);
        fr.run();
        FeatureResult result = fr.result;
        if (!result.isEmpty()) {
            this.suite.saveFeatureResults(result);
        }
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        if (this.suite == null) {
            logger.warn("no feature files scanned");
        } else {
            this.suite.buildResults();
        }
    }
}

