/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit5;

import com.intuit.karate.CallContext;
import com.intuit.karate.FileUtils;
import com.intuit.karate.Resource;
import com.intuit.karate.RunnerOptions;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureExecutionUnit;
import com.intuit.karate.core.FeatureParser;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Tags;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;

public class Karate
implements Iterable<DynamicNode> {
    private final List<String> tags = new ArrayList<String>();
    private final List<String> paths = new ArrayList<String>();
    private Class clazz;

    public Karate relativeTo(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public Karate feature(String ... paths) {
        this.paths.addAll(Arrays.asList(paths));
        return this;
    }

    public Karate tags(String ... tags) {
        this.tags.addAll(Arrays.asList(tags));
        return this;
    }

    @Override
    public Iterator<DynamicNode> iterator() {
        RunnerOptions options = RunnerOptions.fromAnnotationAndSystemProperties(this.paths, this.tags, (Class)this.clazz);
        List resources = FileUtils.scanForFeatureFiles((List)options.getFeatures(), (Class)this.clazz);
        ArrayList<Feature> features = new ArrayList<Feature>(resources.size());
        for (Resource resource : resources) {
            Feature feature = FeatureParser.parse((Resource)resource);
            features.add(feature);
        }
        String tagSelector = Tags.fromCucumberOptionsTags((List)options.getTags());
        ArrayList<DynamicContainer> list = new ArrayList<DynamicContainer>(features.size());
        for (Feature feature : features) {
            FeatureContext featureContext = new FeatureContext(null, feature, tagSelector);
            CallContext callContext = new CallContext(null, true);
            ExecutionContext exec = new ExecutionContext(System.currentTimeMillis(), featureContext, callContext, null, null, null, null);
            FeatureExecutionUnit unit = new FeatureExecutionUnit(exec);
            unit.run();
            exec.result.printStats(null);
            Engine.saveResultHtml((String)(Engine.getBuildDir() + File.separator + "surefire-reports"), (FeatureResult)exec.result, null);
            String testName = feature.getResource().getFileNameWithoutExtension();
            List results = exec.result.getScenarioResults();
            ArrayList<DynamicTest> scenarios = new ArrayList<DynamicTest>(results.size());
            for (ScenarioResult sr : results) {
                Scenario scenario = sr.getScenario();
                String displayName = scenario.getDisplayMeta() + " " + scenario.getName();
                scenarios.add(DynamicTest.dynamicTest((String)displayName, () -> {
                    if (sr.isFailed()) {
                        Assertions.fail((String)sr.getError().getMessage());
                    }
                }));
            }
            DynamicContainer node = DynamicContainer.dynamicContainer((String)testName, scenarios.stream());
            list.add(node);
        }
        return list.iterator();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestFactory
    public static @interface Test {
    }
}

