/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit5;

import com.intuit.karate.CallContext;
import com.intuit.karate.FileUtils;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureExecutionUnit;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.ScenarioExecutionUnit;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;

public class FeatureNode
implements Iterator<DynamicTest>,
Iterable<DynamicTest> {
    public final Feature feature;
    public final ExecutionContext exec;
    public final FeatureExecutionUnit featureUnit;
    Iterator<ScenarioExecutionUnit> iterator;

    public FeatureNode(Feature feature, String tagSelector) {
        this.feature = feature;
        FeatureContext featureContext = new FeatureContext(null, feature, tagSelector);
        CallContext callContext = new CallContext(null, true, new ExecutionHook[0]);
        this.exec = new ExecutionContext(System.currentTimeMillis(), featureContext, callContext, null, null, null);
        this.featureUnit = new FeatureExecutionUnit(this.exec);
        this.featureUnit.init(null);
        ArrayList<ScenarioExecutionUnit> selected = new ArrayList<ScenarioExecutionUnit>();
        for (ScenarioExecutionUnit unit : this.featureUnit.getScenarioExecutionUnits()) {
            if (!this.featureUnit.isSelected(unit)) continue;
            selected.add(unit);
        }
        if (!selected.isEmpty()) {
            ((ScenarioExecutionUnit)selected.get(selected.size() - 1)).setLast(true);
        }
        this.iterator = selected.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public DynamicTest next() {
        ScenarioExecutionUnit unit = this.iterator.next();
        String displayName = unit.scenario.getDisplayMeta() + " " + unit.scenario.getName();
        return DynamicTest.dynamicTest((String)displayName, () -> {
            this.featureUnit.run(unit);
            if (unit.result.isFailed()) {
                Assertions.fail((String)unit.result.getError().getMessage());
            }
            if (unit.isLast()) {
                this.featureUnit.stop();
                this.exec.result.printStats(null);
                Engine.saveResultHtml((String)(FileUtils.getBuildDir() + File.separator + "surefire-reports"), (FeatureResult)this.exec.result, null);
            }
        });
    }

    @Override
    public Iterator<DynamicTest> iterator() {
        return this;
    }
}

