/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit5;

import com.intuit.karate.CallContext;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureExecutionUnit;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.HtmlFeatureReport;
import com.intuit.karate.core.HtmlSummaryReport;
import com.intuit.karate.core.ScenarioExecutionUnit;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;

public class FeatureNode
implements Iterator<DynamicTest>,
Iterable<DynamicTest> {
    public final Feature feature;
    public final ExecutionContext exec;
    public final FeatureExecutionUnit featureUnit;
    public final HtmlSummaryReport summary;
    public final String reportDir;
    Iterator<ScenarioExecutionUnit> iterator;

    public FeatureNode(String reportDir, HtmlSummaryReport summary, Feature feature, String tagSelector) {
        this.reportDir = reportDir;
        this.summary = summary;
        this.feature = feature;
        FeatureContext featureContext = new FeatureContext(null, feature, tagSelector);
        CallContext callContext = new CallContext(null, true, new ExecutionHook[0]);
        this.exec = new ExecutionContext(null, System.currentTimeMillis(), featureContext, callContext, null, null, null);
        this.featureUnit = new FeatureExecutionUnit(this.exec);
        this.featureUnit.init();
        ArrayList<ScenarioExecutionUnit> selected = new ArrayList<ScenarioExecutionUnit>();
        for (ScenarioExecutionUnit unit : this.featureUnit.getScenarioExecutionUnits()) {
            if (!this.featureUnit.isSelected(unit)) continue;
            selected.add(unit);
        }
        if (!selected.isEmpty()) {
            ((ScenarioExecutionUnit)selected.get(selected.size() - 1)).setLast(true);
        }
        this.iterator = selected.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public DynamicTest next() {
        ScenarioExecutionUnit unit = this.iterator.next();
        return DynamicTest.dynamicTest((String)unit.scenario.getNameForReport(), () -> {
            this.featureUnit.run(unit);
            boolean failed = unit.result.isFailed();
            if (unit.isLast() || failed) {
                this.featureUnit.stop();
                FeatureResult result = this.exec.result;
                if (!result.isEmpty()) {
                    result.printStats(null);
                    HtmlFeatureReport.saveFeatureResult((String)this.reportDir, (FeatureResult)result);
                    this.summary.addFeatureResult(result);
                }
            }
            if (failed) {
                Assertions.fail((String)unit.result.getError().getMessage());
            }
        });
    }

    @Override
    public Iterator<DynamicTest> iterator() {
        return this;
    }
}

