/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit5;

import com.intuit.karate.Suite;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.HtmlFeatureReport;
import com.intuit.karate.core.HtmlSummaryReport;
import com.intuit.karate.core.ScenarioIterator;
import com.intuit.karate.core.ScenarioRuntime;
import java.net.URI;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;

public class FeatureNode
implements Iterator<DynamicTest>,
Iterable<DynamicTest> {
    public final Suite suite;
    public final HtmlSummaryReport summary;
    public final FeatureRuntime featureRuntime;
    private final Iterator<ScenarioRuntime> scenarios;

    public FeatureNode(Suite suite, HtmlSummaryReport summary, Feature feature, String tagSelector) {
        this.suite = suite;
        this.summary = summary;
        this.featureRuntime = FeatureRuntime.of((Suite)suite, (Feature)feature);
        this.scenarios = new ScenarioIterator(this.featureRuntime).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.scenarios.hasNext();
    }

    @Override
    public DynamicTest next() {
        ScenarioRuntime runtime = this.scenarios.next();
        return DynamicTest.dynamicTest((String)runtime.scenario.getNameForReport(), (URI)runtime.scenario.getScenarioSrcUri(), () -> {
            if (runtime.isSelectedForExecution()) {
                if (this.featureRuntime.beforeHook()) {
                    runtime.run();
                } else {
                    runtime.logger.info("before-feature hook returned [false], aborting: ", new Object[]{this.featureRuntime});
                }
            }
            boolean failed = runtime.result.isFailed();
            if (!this.scenarios.hasNext()) {
                this.featureRuntime.afterFeature();
                FeatureResult result = this.featureRuntime.result;
                if (!result.isEmpty()) {
                    result.printStats(null);
                    HtmlFeatureReport.saveFeatureResult((String)this.suite.reportDir, (FeatureResult)result);
                    this.summary.addFeatureResult(result);
                }
            }
            if (failed) {
                Assertions.fail((String)runtime.result.getError().getMessage());
            }
        });
    }

    @Override
    public Iterator<DynamicTest> iterator() {
        return this;
    }
}

