/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit5;

import com.intuit.karate.Runner;
import com.intuit.karate.Suite;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.HtmlSummaryReport;
import com.intuit.karate.junit5.FeatureNode;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.TestFactory;

public class Karate
implements Iterable<DynamicNode> {
    private final Runner.Builder builder = Runner.builder();
    private static final HtmlSummaryReport SUMMARY = new HtmlSummaryReport();
    private static boolean shutdownHookRegistered;

    public static Karate run(String ... paths) {
        return new Karate().feature(paths);
    }

    public Karate relativeTo(Class clazz) {
        this.builder.relativeTo(clazz);
        return this;
    }

    public Karate feature(String ... paths) {
        this.builder.path(paths);
        return this;
    }

    public Karate tags(String ... tags) {
        this.builder.tags(tags);
        return this;
    }

    public Runner.Builder builder() {
        return this.builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DynamicNode> iterator() {
        final Suite suite = new Suite(this.builder);
        ArrayList<DynamicContainer> list = new ArrayList<DynamicContainer>();
        for (Feature feature : suite.features) {
            FeatureNode featureNode = new FeatureNode(suite, SUMMARY, feature, suite.tagSelector);
            String testName = feature.getResource().getFileNameWithoutExtension();
            DynamicContainer node = DynamicContainer.dynamicContainer((String)testName, (Iterable)featureNode);
            list.add(node);
        }
        if (list.isEmpty()) {
            Assertions.fail((String)("no features or scenarios found: " + this.builder));
        }
        HtmlSummaryReport htmlSummaryReport = SUMMARY;
        synchronized (htmlSummaryReport) {
            if (!shutdownHookRegistered) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        SUMMARY.save(suite.reportDir);
                    }
                });
                shutdownHookRegistered = true;
            }
        }
        return list.iterator();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestFactory
    public static @interface Test {
    }
}

