/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.mock.servlet;

import com.intuit.karate.ScriptValue;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.MultiPartItem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Part;

public class MockMultiPart
implements Part {
    private final MultiPartItem item;
    private final byte[] bytes;
    private final Map<String, String> headers;
    private static final String CONTENT_TYPE = "content-type";
    private static final String CONTENT_DISPOSITION = "content-disposition";

    public MockMultiPart(MultiPartItem item) {
        this.item = item;
        ScriptValue sv = item.getValue();
        if (sv.isNull()) {
            this.bytes = new byte[0];
        } else {
            String temp = sv.getAsString();
            this.bytes = temp.getBytes();
        }
        this.headers = new HashMap<String, String>(2);
        String ct = item.getContentType();
        if (ct == null) {
            ct = HttpUtils.getContentType((ScriptValue)sv);
        }
        this.headers.put(CONTENT_TYPE, ct);
        String disposition = "form-data";
        String filename = item.getFilename();
        if (filename != null) {
            disposition = disposition + "; filename=\"" + filename + "\"";
        }
        disposition = disposition + "; name=\"" + item.getName() + "\"";
        this.headers.put(CONTENT_DISPOSITION, disposition);
    }

    public boolean isFile() {
        return this.item.getValue().getType() == ScriptValue.Type.INPUT_STREAM;
    }

    public String getValue() {
        return this.item.getValue().getAsString();
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public String getContentType() {
        return this.headers.get(CONTENT_TYPE);
    }

    public String getName() {
        return this.item.getName();
    }

    public long getSize() {
        return this.bytes.length;
    }

    public void write(String string) throws IOException {
    }

    public void delete() throws IOException {
    }

    public String getHeader(String string) {
        return this.headers.get(string);
    }

    public Collection<String> getHeaders(String string) {
        return Collections.singletonList(this.headers.get(string));
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }
}

