/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.mock.servlet;

import com.intuit.karate.FileUtils;
import com.intuit.karate.ScriptContext;
import com.intuit.karate.http.HttpBody;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpConfig;
import com.intuit.karate.http.HttpRequestBuilder;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.http.MultiValuedMap;
import com.intuit.karate.mock.servlet.MockMultiPart;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;

public abstract class MockHttpClient
extends HttpClient<HttpBody> {
    private static final Logger logger = LoggerFactory.getLogger(MockHttpClient.class);
    private URI uri;
    private MockHttpServletRequestBuilder requestBuilder;
    private final AtomicInteger counter = new AtomicInteger();

    protected abstract Servlet getServlet(HttpRequestBuilder var1);

    protected abstract ServletContext getServletContext();

    public void configure(HttpConfig config, ScriptContext context) {
    }

    protected HttpBody getEntity(List<MultiPartItem> items, String mediaType) {
        return HttpBody.multiPart(items, (String)mediaType);
    }

    protected HttpBody getEntity(MultiValuedMap formFields, String mediaType) {
        return HttpBody.formFields((MultiValuedMap)formFields, (String)mediaType);
    }

    protected HttpBody getEntity(InputStream stream, String mediaType) {
        return HttpBody.stream((InputStream)stream, (String)mediaType);
    }

    protected HttpBody getEntity(String content, String mediaType) {
        return HttpBody.string((String)content, (String)mediaType);
    }

    protected void buildUrl(String url) {
        String method = this.request.getMethod();
        try {
            this.uri = new URI(url);
            this.requestBuilder = MockMvcRequestBuilders.request((String)method, (URI)this.uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void buildPath(String path) {
        String url = this.uri.toString();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.buildUrl(url + path);
    }

    protected void buildParam(String name, Object ... values) {
        ArrayList<String> list = new ArrayList<String>(values.length);
        for (Object o : values) {
            list.add(o == null ? null : o.toString());
        }
        this.requestBuilder.param(name, list.toArray(new String[0]));
    }

    protected void buildHeader(String name, Object value, boolean replace) {
        this.requestBuilder.header(name, new Object[]{value});
    }

    protected void buildCookie(com.intuit.karate.http.Cookie c) {
        Cookie cookie = new Cookie(c.getName(), c.getValue());
        this.requestBuilder.cookie(new Cookie[]{cookie});
        for (Map.Entry entry : c.entrySet()) {
            if (entry.getValue() == null) continue;
            switch ((String)entry.getKey()) {
                case "domain": {
                    cookie.setDomain((String)entry.getValue());
                    break;
                }
                case "path": {
                    cookie.setPath((String)entry.getValue());
                }
            }
        }
        if (cookie.getDomain() == null) {
            cookie.setDomain(this.uri.getHost());
        }
    }

    protected HttpResponse makeHttpRequest(HttpBody entity, ScriptContext context) {
        byte[] bytes;
        logger.info("making mock http client request: {} - {}", (Object)this.request.getMethod(), (Object)this.getRequestUri());
        MockHttpServletRequest req = this.requestBuilder.buildRequest(this.getServletContext());
        if (entity != null) {
            bytes = entity.getBytes();
            req.setContentType(entity.getContentType());
            if (entity.isMultiPart()) {
                for (MultiPartItem item : entity.getParts()) {
                    MockMultiPart part = new MockMultiPart(item);
                    req.addPart((Part)part);
                    if (part.isFile()) continue;
                    req.addParameter(part.getName(), part.getValue());
                }
            } else if (entity.isUrlEncoded()) {
                req.addParameters(entity.getParameters());
            } else {
                req.setContent(bytes);
            }
        } else {
            bytes = null;
        }
        MockHttpServletResponse res = new MockHttpServletResponse();
        this.logRequest(req, bytes);
        long startTime = System.currentTimeMillis();
        try {
            this.getServlet(this.request).service((ServletRequest)req, (ServletResponse)res);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HttpResponse response = new HttpResponse(startTime, System.currentTimeMillis());
        bytes = res.getContentAsByteArray();
        this.logResponse(res, bytes);
        response.setUri(this.getRequestUri());
        response.setBody(bytes);
        response.setStatus(res.getStatus());
        for (Cookie c : res.getCookies()) {
            com.intuit.karate.http.Cookie cookie = new com.intuit.karate.http.Cookie(c.getName(), c.getValue());
            cookie.put((Object)"domain", (Object)c.getDomain());
            cookie.put((Object)"path", (Object)c.getPath());
            cookie.put((Object)"secure", (Object)(c.getSecure() + ""));
            cookie.put((Object)"max-age", (Object)(c.getMaxAge() + ""));
            cookie.put((Object)"version", (Object)(c.getVersion() + ""));
            response.addCookie(cookie);
        }
        for (String headerName : res.getHeaderNames()) {
            response.putHeader(headerName, res.getHeaders(headerName));
        }
        return response;
    }

    protected String getRequestUri() {
        return this.uri.toString();
    }

    private void logRequest(MockHttpServletRequest req, byte[] bytes) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        int id = this.counter.incrementAndGet();
        StringBuilder sb = new StringBuilder();
        sb.append('\n').append(id).append(" > ").append(req.getMethod()).append(' ').append(req.getRequestURL()).append('\n');
        MockHttpClient.logRequestHeaders(sb, id, req);
        MockHttpClient.logBody(sb, bytes, req.getContentType());
        logger.debug(sb.toString());
    }

    private void logResponse(MockHttpServletResponse res, byte[] bytes) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        int id = this.counter.get();
        StringBuilder sb = new StringBuilder();
        sb.append('\n').append(id).append(" < ").append(res.getStatus()).append('\n');
        MockHttpClient.logResponseHeaders(sb, id, res);
        MockHttpClient.logBody(sb, bytes, res.getContentType());
        logger.debug(sb.toString());
    }

    private static void logRequestHeaders(StringBuilder sb, int id, MockHttpServletRequest request) {
        TreeSet keys = new TreeSet(Collections.list(request.getHeaderNames()));
        for (String key : keys) {
            ArrayList entries = Collections.list(request.getHeaders(key));
            sb.append(id).append(' ').append('>').append(' ').append(key).append(": ").append(entries.size() == 1 ? entries.get(0) : entries).append('\n');
        }
    }

    private static void logResponseHeaders(StringBuilder sb, int id, MockHttpServletResponse response) {
        TreeSet keys = new TreeSet(response.getHeaderNames());
        for (String key : keys) {
            List entries = response.getHeaders(key);
            sb.append(id).append(' ').append('<').append(' ').append(key).append(": ").append(entries.size() == 1 ? entries.get(0) : entries).append('\n');
        }
    }

    private static void logBody(StringBuilder sb, byte[] bytes, String contentType) {
        if (bytes != null && HttpUtils.isPrintable((String)contentType)) {
            sb.append(FileUtils.toString((byte[])bytes));
        }
    }
}

