/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.mock.servlet;

import com.intuit.karate.Config;
import com.intuit.karate.FileUtils;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.http.HttpBody;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpLogModifier;
import com.intuit.karate.http.HttpRequestBuilder;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.http.MultiValuedMap;
import com.intuit.karate.mock.servlet.MockMultiPart;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.Part;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;

public abstract class MockHttpClient
extends HttpClient<HttpBody> {
    private URI uri;
    private MockHttpServletRequestBuilder requestBuilder;
    private final AtomicInteger counter = new AtomicInteger();

    protected abstract Servlet getServlet(HttpRequestBuilder var1);

    protected abstract ServletContext getServletContext();

    public void configure(Config config, ScenarioContext context) {
    }

    protected HttpBody getEntity(List<MultiPartItem> items, String mediaType) {
        return HttpBody.multiPart(items, (String)mediaType);
    }

    protected HttpBody getEntity(MultiValuedMap formFields, String mediaType) {
        return HttpBody.formFields((MultiValuedMap)formFields, (String)mediaType);
    }

    protected HttpBody getEntity(InputStream stream, String mediaType) {
        return HttpBody.stream((InputStream)stream, (String)mediaType);
    }

    protected HttpBody getEntity(String content, String mediaType) {
        return HttpBody.string((String)content, (String)mediaType);
    }

    protected void buildUrl(String url) {
        String method = this.request.getMethod();
        try {
            this.uri = new URI(url);
            this.requestBuilder = MockMvcRequestBuilders.request((String)method, (URI)this.uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void buildPath(String path) {
        String url = this.uri.toString();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.buildUrl(url + path);
    }

    protected void buildParam(String name, Object ... values) {
        ArrayList<String> list = new ArrayList<String>(values.length);
        for (Object o : values) {
            list.add(o == null ? null : o.toString());
        }
        this.requestBuilder.param(name, list.toArray(new String[0]));
    }

    protected void buildHeader(String name, Object value, boolean replace) {
        this.requestBuilder.header(name, new Object[]{value});
    }

    protected void buildCookie(com.intuit.karate.http.Cookie c) {
        Cookie cookie = new Cookie(c.getName(), c.getValue());
        this.requestBuilder.cookie(new Cookie[]{cookie});
        for (Map.Entry entry : c.entrySet()) {
            if (entry.getValue() == null) continue;
            switch ((String)entry.getKey()) {
                case "domain": {
                    cookie.setDomain((String)entry.getValue());
                    break;
                }
                case "path": {
                    cookie.setPath((String)entry.getValue());
                }
            }
        }
        if (cookie.getDomain() == null) {
            cookie.setDomain(this.uri.getHost());
        }
    }

    protected HttpResponse makeHttpRequest(HttpBody entity, ScenarioContext context) {
        boolean showLog;
        byte[] bytes;
        MockHttpServletRequest req = this.requestBuilder.buildRequest(this.getServletContext());
        if (entity != null) {
            bytes = entity.getBytes();
            req.setContentType(entity.getContentType());
            if (entity.isMultiPart()) {
                for (MultiPartItem item : entity.getParts()) {
                    MockMultiPart part = new MockMultiPart(item);
                    req.addPart((Part)part);
                    if (part.isFile()) continue;
                    req.addParameter(part.getName(), part.getValue());
                }
            } else if (entity.isUrlEncoded()) {
                req.addParameters(entity.getParameters());
            } else {
                req.setContent(bytes);
            }
        } else {
            bytes = null;
        }
        MockHttpServletResponse res = new MockHttpServletResponse();
        String uri = req.getRequestURL().toString();
        HttpLogModifier logModifier = context.getConfig().getLogModifier();
        logModifier = logModifier == null ? null : (logModifier.enableForUri(uri) ? logModifier : null);
        boolean bl = showLog = !context.isReportDisabled() && context.getConfig().isShowLog();
        if (showLog) {
            context.logger.debug(this.logRequest(uri, logModifier, req, bytes), new Object[0]);
        }
        long startTime = System.currentTimeMillis();
        try {
            this.getServlet(this.request).service((ServletRequest)req, (ServletResponse)res);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            context.logger.error("mock servlet request failed: {}", new Object[]{message});
            throw new RuntimeException(e);
        }
        HttpResponse response = new HttpResponse(startTime, System.currentTimeMillis());
        bytes = res.getContentAsByteArray();
        if (showLog) {
            context.logger.debug(this.logResponse(uri, logModifier, res, bytes, response.getResponseTime()), new Object[0]);
        }
        response.setUri(this.getRequestUri());
        response.setBody(bytes);
        response.setStatus(res.getStatus());
        for (Cookie c : res.getCookies()) {
            com.intuit.karate.http.Cookie cookie = new com.intuit.karate.http.Cookie(c.getName(), c.getValue());
            cookie.put((Object)"domain", (Object)c.getDomain());
            cookie.put((Object)"path", (Object)c.getPath());
            cookie.put((Object)"secure", (Object)(c.getSecure() + ""));
            cookie.put((Object)"max-age", (Object)(c.getMaxAge() + ""));
            cookie.put((Object)"version", (Object)(c.getVersion() + ""));
            response.addCookie(cookie);
        }
        for (String headerName : res.getHeaderNames()) {
            response.putHeader(headerName, res.getHeaders(headerName));
        }
        return response;
    }

    protected String getRequestUri() {
        return this.uri.toString();
    }

    private String logRequest(String uri, HttpLogModifier logModifier, MockHttpServletRequest req, byte[] bytes) {
        String maskedUri = logModifier == null ? uri : logModifier.uri(uri);
        int id = this.counter.incrementAndGet();
        StringBuilder sb = new StringBuilder();
        sb.append("request:\n").append(id).append(" > ").append(req.getMethod()).append(' ').append(maskedUri).append('\n');
        MockHttpClient.logRequestHeaders(logModifier, sb, id, req);
        MockHttpClient.logBody(true, uri, logModifier, sb, bytes, req.getContentType());
        return sb.toString();
    }

    private String logResponse(String uri, HttpLogModifier logModifier, MockHttpServletResponse res, byte[] bytes, long responseTime) {
        int id = this.counter.get();
        StringBuilder sb = new StringBuilder();
        sb.append("response time in milliseconds: ").append(responseTime).append('\n');
        sb.append(id).append(" < ").append(res.getStatus()).append('\n');
        MockHttpClient.logResponseHeaders(logModifier, sb, id, res);
        MockHttpClient.logBody(false, uri, logModifier, sb, bytes, res.getContentType());
        return sb.toString();
    }

    private static void logRequestHeaders(HttpLogModifier logModifier, StringBuilder sb, int id, MockHttpServletRequest request) {
        TreeSet keys = new TreeSet(Collections.list(request.getHeaderNames()));
        for (String key : keys) {
            ArrayList<String> entries = Collections.list(request.getHeaders(key));
            sb.append(id).append(' ').append('>').append(' ').append(key).append(": ");
            MockHttpClient.logHeaderValues(logModifier, key, entries, sb);
            sb.append('\n');
        }
    }

    private static void logResponseHeaders(HttpLogModifier logModifier, StringBuilder sb, int id, MockHttpServletResponse response) {
        TreeSet keys = new TreeSet(response.getHeaderNames());
        for (String key : keys) {
            List entries = response.getHeaders(key);
            sb.append(id).append(' ').append('<').append(' ').append(key).append(": ");
            MockHttpClient.logHeaderValues(logModifier, key, entries, sb);
            sb.append('\n');
        }
    }

    private static void logHeaderValues(HttpLogModifier logModifier, String key, List<String> entries, StringBuilder sb) {
        if (logModifier == null) {
            sb.append(entries.size() == 1 ? entries.get(0) : entries);
        } else if (entries.size() == 1) {
            sb.append(logModifier.header(key, entries.get(0)));
        } else {
            ArrayList<String> masked = new ArrayList<String>(entries.size());
            for (String entry : entries) {
                masked.add(logModifier.header(key, entry));
            }
            sb.append(masked);
        }
    }

    private static void logBody(boolean request, String uri, HttpLogModifier logModifier, StringBuilder sb, byte[] bytes, String contentType) {
        if (bytes != null && HttpUtils.isPrintable((String)contentType)) {
            String body = FileUtils.toString((byte[])bytes);
            if (logModifier != null) {
                body = request ? logModifier.request(uri, body) : logModifier.response(uri, body);
            }
            sb.append(body).append('\n');
        }
    }
}

