/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.mock.servlet;

import com.intuit.karate.FileUtils;
import com.intuit.karate.http.ResourceType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.Part;

public class MockPart
implements Part {
    private final Map<String, Object> map;
    private final byte[] bytes;
    private final String contentType;

    public MockPart(Map<String, Object> map) {
        this.map = map;
        Object value = map.get("value");
        if (value instanceof byte[]) {
            this.bytes = (byte[])value;
            this.contentType = (String)map.get("contentType");
        } else {
            this.bytes = FileUtils.toBytes((String)value.toString());
            this.contentType = ResourceType.TEXT.contentType;
        }
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return (String)this.map.get("name");
    }

    public long getSize() {
        return this.bytes.length;
    }

    public void write(String fileName) throws IOException {
    }

    public void delete() throws IOException {
    }

    public String getHeader(String name) {
        if (name.equalsIgnoreCase("content-disposition")) {
            String fileName;
            String disp = "form-data;";
            String partName = this.getName();
            if (partName != null) {
                disp = disp + " name=\"" + partName + "\";";
            }
            if ((fileName = (String)this.map.get("filename")) != null) {
                disp = disp + " filename=\"" + fileName + "\"";
            }
            return disp;
        }
        return (String)this.map.get(name);
    }

    public Collection<String> getHeaders(String name) {
        String value = (String)this.map.get(name);
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(value);
    }

    public Collection<String> getHeaderNames() {
        return this.map.keySet();
    }
}

