/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.mock.servlet;

import com.intuit.karate.Logger;
import com.intuit.karate.core.Config;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpLogger;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.Response;
import com.intuit.karate.mock.servlet.MockPart;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Part;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;

public class MockHttpClient
implements HttpClient {
    private final ScenarioEngine engine;
    private final Logger logger;
    private final HttpLogger httpLogger;
    private final Servlet servlet;
    private final ServletContext servletContext;

    public MockHttpClient(ScenarioEngine engine, Servlet servlet, ServletContext servletContext) {
        this.engine = engine;
        this.logger = engine.logger;
        this.httpLogger = new HttpLogger(this.logger);
        this.servlet = servlet;
        this.servletContext = servletContext;
    }

    public void setConfig(Config config) {
    }

    public Config getConfig() {
        return this.engine.getConfig();
    }

    public Response invoke(HttpRequest hr) {
        URI uri;
        Request request = hr.toRequest();
        request.processBody();
        try {
            uri = new URI(request.getUrlAndPath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MockHttpServletRequestBuilder builder = MockMvcRequestBuilders.request((String)request.getMethod(), (URI)uri).pathInfo(uri.getPath());
        if (request.getHeaders() != null) {
            request.getHeaders().forEach((k, vals) -> builder.header(k, vals.toArray()));
            request.getCookies().forEach(c -> {
                javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(c.name(), c.value());
                if (c.domain() != null) {
                    cookie.setDomain(c.domain());
                }
                if (c.path() != null) {
                    cookie.setPath(c.path());
                }
                cookie.setHttpOnly(c.isHttpOnly());
                cookie.setSecure(c.isSecure());
                cookie.setMaxAge((int)c.maxAge());
                builder.cookie(new javax.servlet.http.Cookie[]{cookie});
            });
        }
        builder.content(request.getBody());
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpServletRequest req = builder.buildRequest(this.servletContext);
        if (request.isMultiPart()) {
            request.getMultiParts().forEach((name, v) -> {
                for (Map map : v) {
                    req.addPart((Part)new MockPart(map));
                }
            });
            request.getParams().forEach((name, v) -> {
                for (String value : v) {
                    req.addParameter(name, value);
                }
            });
        }
        Map<String, List<String>> headers = MockHttpClient.toHeaders(MockHttpClient.toCollection(req.getHeaderNames()), name -> MockHttpClient.toCollection(req.getHeaders(name)));
        request.setHeaders(headers);
        this.httpLogger.logRequest(this.engine.getConfig(), hr);
        try {
            this.servlet.service((ServletRequest)req, (ServletResponse)res);
            hr.setEndTime(System.currentTimeMillis());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        headers = MockHttpClient.toHeaders(res.getHeaderNames(), name -> res.getHeaders(name));
        javax.servlet.http.Cookie[] cookies = res.getCookies();
        ArrayList<String> cookieValues = new ArrayList<String>(cookies.length);
        for (javax.servlet.http.Cookie c2 : cookies) {
            DefaultCookie dc = new DefaultCookie(c2.getName(), c2.getValue());
            dc.setDomain(c2.getDomain());
            dc.setMaxAge((long)c2.getMaxAge());
            dc.setSecure(c2.getSecure());
            dc.setPath(c2.getPath());
            dc.setHttpOnly(c2.isHttpOnly());
            cookieValues.add(ServerCookieEncoder.STRICT.encode((Cookie)dc));
        }
        if (!cookieValues.isEmpty()) {
            headers.put("Set-Cookie", cookieValues);
        }
        Response response = new Response(res.getStatus(), headers, res.getContentAsByteArray());
        this.httpLogger.logResponse(this.getConfig(), hr, response);
        return response;
    }

    private static Collection<String> toCollection(Enumeration<String> values) {
        ArrayList<String> list = new ArrayList<String>();
        while (values.hasMoreElements()) {
            list.add(values.nextElement());
        }
        return list;
    }

    private static Map<String, List<String>> toHeaders(Collection<String> names, Function<String, Collection<String>> valuesFn) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>(names.size());
        for (String name : names) {
            Collection<String> values = valuesFn.apply(name);
            ArrayList<String> list = new ArrayList<String>(values.size());
            for (String value : values) {
                list.add(value);
            }
            map.put(name, list);
        }
        return map;
    }
}

