/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.netty;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Results;
import com.intuit.karate.Runner;
import com.intuit.karate.StringUtils;
import com.intuit.karate.exception.KarateException;
import com.intuit.karate.netty.FeatureServer;
import com.intuit.karate.netty.NettyUtils;
import com.intuit.karate.ui.App;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class Main
implements Callable<Void> {
    private static final String DEFAULT_OUTPUT_DIR = "target";
    private static final String LOGBACK_CONFIG = "logback.configurationFile";
    private static final String CERT_FILE = "cert.pem";
    private static final String KEY_FILE = "key.pem";
    private static Logger logger;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display this help message"})
    boolean help;
    @CommandLine.Option(names={"-m", "--mock"}, description={"mock server file"})
    File mock;
    @CommandLine.Option(names={"-p", "--port"}, description={"mock server port (required for --mock)"})
    Integer port;
    @CommandLine.Option(names={"-s", "--ssl"}, description={"use ssl / https, will use 'cert.pem' and 'key.pem' if they exist in the working directory, or generate them"})
    boolean ssl;
    @CommandLine.Option(names={"-c", "--cert"}, description={"ssl certificate (default: cert.pem)"})
    File cert;
    @CommandLine.Option(names={"-k", "--key"}, description={"ssl private key (default: key.pem)"})
    File key;
    @CommandLine.Option(names={"-t", "--tags"}, description={"cucumber tags - e.g. '@smoke,~@ignore'"})
    List<String> tags;
    @CommandLine.Option(names={"-T", "--threads"}, description={"number of threads when running tests"})
    int threads = 1;
    @CommandLine.Option(names={"-o", "--output"}, description={"directory where logs and reports are output (default 'target')"})
    String output = "target";
    @CommandLine.Parameters(description={"one or more tests (features) or search-paths to run"})
    List<String> tests;
    @CommandLine.Option(names={"-e", "--env"}, description={"value of 'karate.env'"})
    String env;
    @CommandLine.Option(names={"-u", "--ui"}, description={"show user interface"})
    boolean ui;

    public static void main(String[] args) {
        boolean isOutputArg = false;
        String outputDir = DEFAULT_OUTPUT_DIR;
        for (String s : args) {
            if (isOutputArg) {
                outputDir = s;
                isOutputArg = false;
            }
            if (!s.startsWith("-o") && !s.startsWith("--output")) continue;
            int pos = s.indexOf(61);
            if (pos != -1) {
                outputDir = s.substring(pos + 1);
                continue;
            }
            isOutputArg = true;
        }
        System.setProperty("karate.output.dir", outputDir);
        String logbackConfig = System.getProperty(LOGBACK_CONFIG);
        if (StringUtils.isBlank((String)logbackConfig)) {
            System.setProperty(LOGBACK_CONFIG, "logback-netty.xml");
        }
        logger = LoggerFactory.getLogger(Main.class);
        logger.info("Karate version: {}", (Object)FileUtils.getKarateVersion());
        final CommandLine cmd = new CommandLine((Object)new Main());
        CommandLine.DefaultExceptionHandler exceptionHandler = new CommandLine.DefaultExceptionHandler(){

            public Object handleExecutionException(CommandLine.ExecutionException ex, CommandLine.ParseResult parseResult) {
                if (ex.getCause() instanceof KarateException) {
                    throw new CommandLine.ExecutionException(cmd, ex.getCause().getMessage());
                }
                throw ex;
            }
        };
        cmd.parseWithHandlers((CommandLine.IParseResultHandler2)new CommandLine.RunLast(), (CommandLine.IExceptionHandler2)exceptionHandler, args);
        System.exit(0);
    }

    @Override
    public Void call() throws Exception {
        FeatureServer server;
        if (this.tests != null) {
            if (this.ui) {
                App.main((String[])new String[]{new File(this.tests.get(0)).getAbsolutePath(), this.env});
            } else {
                if (this.env != null) {
                    System.setProperty("karate.env", this.env);
                }
                String configDir = System.getProperty("karate.config.dir");
                if ((configDir = StringUtils.trimToNull((String)configDir)) == null) {
                    System.setProperty("karate.config.dir", new File("").getAbsolutePath());
                }
                List fixed = this.tests.stream().map(f -> new File((String)f).getAbsolutePath()).collect(Collectors.toList());
                Results results = Runner.parallel(this.tags, fixed, (int)this.threads, (String)this.output);
                Collection jsonFiles = org.apache.commons.io.FileUtils.listFiles((File)new File(this.output), (String[])new String[]{"json"}, (boolean)true);
                ArrayList jsonPaths = new ArrayList(jsonFiles.size());
                jsonFiles.forEach(file -> jsonPaths.add(file.getAbsolutePath()));
                Configuration config = new Configuration(new File(this.output), new Date() + "");
                ReportBuilder reportBuilder = new ReportBuilder(jsonPaths, config);
                reportBuilder.generateReports();
                if (results.getFailCount() > 0) {
                    throw new KarateException("there are test failures");
                }
            }
            return null;
        }
        if (this.ui || this.mock == null) {
            App.main((String[])new String[0]);
            return null;
        }
        if (this.mock != null && this.port == null) {
            System.err.println("--port required for --mock option");
            CommandLine.usage((Object)this, (PrintStream)System.err);
            return null;
        }
        if (this.cert != null) {
            this.ssl = true;
        }
        if (this.ssl) {
            if (this.cert == null) {
                this.cert = new File(CERT_FILE);
                this.key = new File(KEY_FILE);
            }
            if (!this.cert.exists() || !this.key.exists()) {
                logger.warn("ssl requested, but cert.pem and/or key.pem not found in working directory, will create");
                try {
                    NettyUtils.createSelfSignedCertificate((File)this.cert, (File)this.key);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                logger.info("ssl on, using existing files: {} and {}", (Object)CERT_FILE, (Object)KEY_FILE);
            }
            server = FeatureServer.start((File)this.mock, (int)this.port, (File)this.cert, (File)this.key, null);
        } else {
            server = FeatureServer.start((File)this.mock, (int)this.port, (boolean)false, null);
        }
        server.waitSync();
        return null;
    }
}

