/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot;

import com.intuit.karate.robot.Location;
import com.intuit.karate.robot.Region;
import com.intuit.karate.robot.RobotBase;
import java.util.List;
import java.util.Map;

public interface Element {
    public RobotBase getRobot();

    default public Location inset(int fromLeft, int fromTop) {
        Region r = this.getRegion();
        Location l = new Location(r.robot, r.x + fromLeft, r.y + fromTop);
        return l;
    }

    public boolean isPresent();

    public boolean isImage();

    public boolean isEnabled();

    default public Map<String, Object> getPosition() {
        return this.getRegion().getPosition();
    }

    public Region getRegion();

    default public byte[] screenshot() {
        return this.getRegion().screenshot();
    }

    public Element focus();

    default public Element focus(String locator) {
        RobotBase robot = this.getRobot();
        return robot.locate(robot.getHighlightDuration(), this, locator).focus();
    }

    default public Element move(int fromLeft, int fromTop) {
        this.inset(fromLeft, fromTop).move();
        return this;
    }

    public Element click();

    default public Element click(String locator) {
        RobotBase robot = this.getRobot();
        return robot.locate(robot.getHighlightDuration(), this, locator).click();
    }

    public Element clear();

    default public Element click(int fromLeft, int fromTop) {
        this.inset(fromLeft, fromTop).click();
        return this;
    }

    default public Element doubleClick(int fromLeft, int fromTop) {
        this.inset(fromLeft, fromTop).doubleClick();
        return this;
    }

    public Element move();

    public Element press();

    public Element release();

    public String getName();

    public String getValue();

    public Element input(String var1);

    public Element delay(int var1);

    default public Element retry() {
        this.getRobot().retry();
        return this;
    }

    default public Element retry(int count) {
        this.getRobot().retry(count);
        return this;
    }

    default public Element waitFor(String locator) {
        return this.getRobot().retryForAny(true, this, locator);
    }

    default public Element waitForAny(String locator1, String locator2) {
        return this.getRobot().retryForAny(true, this, locator1, locator2);
    }

    default public Element waitForAny(String[] locators) {
        return this.getRobot().retryForAny(true, this, locators);
    }

    default public Element retry(Integer count, Integer interval) {
        this.getRobot().retry(count, interval);
        return this;
    }

    default public Element locate(String locator) {
        RobotBase robot = this.getRobot();
        return robot.locate(robot.getHighlightDuration(), this, locator);
    }

    default public List<Element> locateAll(String locator) {
        RobotBase robot = this.getRobot();
        return robot.locateAll(robot.getHighlightDuration(), this, locator);
    }

    default public Element highlight(int millis) {
        this.getRegion().highlight(millis);
        return this;
    }

    default public Element highlight() {
        return this.highlight(3000);
    }

    default public Element highlight(String locator) {
        RobotBase robot = this.getRobot();
        return robot.locate(3000, this, locator);
    }

    default public List<Element> highlightAll(String locator) {
        RobotBase robot = this.getRobot();
        return robot.locateAll(3000, this, locator);
    }

    default public Element optional(String locator) {
        return this.getRobot().optional(this, locator);
    }

    default public boolean exists(String locator) {
        return this.optional(locator).isPresent();
    }

    public List<Element> getChildren();

    public Element getParent();

    public <T> T toNative();

    public String getDebugString();

    public Element select();

    default public Element select(String locator) {
        RobotBase robot = this.getRobot();
        return robot.locate(robot.getHighlightDuration(), this, locator).select();
    }

    default public String extract() {
        return this.extract(null, false);
    }

    default public String extract(String lang, boolean debug) {
        return this.getRegion().extract(lang, debug);
    }

    default public Element activate() {
        this.getRobot().setActive(this);
        return this;
    }

    default public void debugCapture() {
        this.getRegion().debugCapture();
    }

    default public String debugExtract() {
        return this.extract(null, true);
    }

    default public String debugExtract(String lang) {
        return this.extract(lang, true);
    }
}

