/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ffmpeg
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Ffmpeg.class);
    private final FFmpegFrameRecorder recorder;
    private final Robot robot;
    private final int width;
    private final int height;
    private static final int FRAME_INTERVAL = 200;

    private BufferedImage capture() {
        BufferedImage image = this.robot.createScreenCapture(new Rectangle(0, 0, this.width, this.height));
        BufferedImage bi = new BufferedImage(this.width, this.height, 5);
        Graphics2D g = bi.createGraphics();
        g.drawImage(image, 0, 0, this.width, this.height, null);
        return bi;
    }

    public Ffmpeg() {
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            this.width = tk.getScreenSize().width;
            this.height = tk.getScreenSize().height;
            this.robot = new Robot();
            File file = new File("target/karate.mp4");
            this.recorder = FFmpegFrameRecorder.createDefault((File)file, (int)this.width, (int)this.height);
            this.recorder.setFrameRate(5.0);
            this.recorder.setPixelFormat(0);
            this.recorder.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        int count = 0;
        try {
            while (count++ < 100) {
                long time = System.currentTimeMillis();
                BufferedImage bi = this.capture();
                Frame frame = Java2DFrameUtils.toFrame((BufferedImage)bi);
                this.recorder.record(frame);
                long elapsed = System.currentTimeMillis() - time;
                if (elapsed < 200L) {
                    Thread.sleep(200L - elapsed);
                    continue;
                }
                logger.debug("slow: " + elapsed);
            }
            this.recorder.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

