/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot;

import com.intuit.karate.robot.Element;
import com.intuit.karate.robot.Region;
import com.intuit.karate.robot.RobotBase;
import java.util.Collections;
import java.util.List;

public class ImageElement
implements Element {
    private final Region region;
    private final RobotBase robot;
    private final String value;

    public ImageElement(Region region) {
        this(region, null);
    }

    public ImageElement(Region region, String value) {
        this.region = region;
        this.robot = region.robot;
        this.value = value == null ? region.toString() : value;
    }

    @Override
    public RobotBase getRobot() {
        return this.robot;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isImage() {
        return true;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public Element focus() {
        this.region.click();
        return this;
    }

    @Override
    public Element click() {
        this.region.click();
        return this;
    }

    @Override
    public Element move() {
        this.region.move();
        return this;
    }

    @Override
    public Element press() {
        this.region.press();
        return this;
    }

    @Override
    public Element release() {
        this.region.release();
        return this;
    }

    @Override
    public String getName() {
        return this.region.toString();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Element input(String value) {
        this.region.click();
        this.robot.input(value);
        return this;
    }

    @Override
    public Element clear() {
        this.region.click();
        this.robot.clearFocused();
        return this;
    }

    @Override
    public Element delay(int millis) {
        this.robot.delay(millis);
        return this;
    }

    @Override
    public List<Element> getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Element getParent() {
        return null;
    }

    public Region toNative() {
        return this.region;
    }

    @Override
    public String getDebugString() {
        return this.getName();
    }

    @Override
    public Element select() {
        return this;
    }
}

