/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot;

import com.intuit.karate.robot.Region;
import com.intuit.karate.robot.RobotBase;
import java.util.HashMap;
import java.util.Map;

public class Location {
    public final RobotBase robot;
    public final int x;
    public final int y;

    public Location(RobotBase robot, int x, int y) {
        this.robot = robot;
        this.x = x;
        this.y = y;
    }

    public Location move() {
        this.robot.move(this.x, this.y);
        return this;
    }

    public Location click() {
        return this.click(1);
    }

    public Location click(int num) {
        this.robot.move(this.x, this.y);
        this.robot.click(num);
        return this;
    }

    public Location doubleClick() {
        this.robot.move(this.x, this.y);
        this.robot.doubleClick();
        return this;
    }

    public Location press() {
        this.robot.move(this.x, this.y);
        this.robot.press();
        return this;
    }

    public Location release() {
        this.robot.move(this.x, this.y);
        this.robot.release();
        return this;
    }

    public Location highlight() {
        return this.highlight(3000);
    }

    public Location highlight(int duration) {
        new Region(this.robot, this.x - 5, this.y - 5, 10, 10).highlight(duration);
        return this;
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("x", this.x);
        map.put("y", this.y);
        return map;
    }

    public String toString() {
        return this.asMap().toString();
    }
}

