/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot;

import com.intuit.karate.robot.Region;
import com.intuit.karate.robot.RobotBase;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacv.CanvasFrame;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.bytedeco.javacv.Java2DFrameUtils;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.Point2f;
import org.bytedeco.opencv.opencv_core.Point2fVector;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenCvUtils {
    private static final Logger logger = LoggerFactory.getLogger(OpenCvUtils.class);
    private static final int TARGET_MINVAL_FACTOR = 150;
    private static final int BLOCK_SIZE = 5;

    private OpenCvUtils() {
    }

    public static Region find(int strictness, RobotBase robot, Region source, byte[] bytes, boolean resize) {
        Region found = OpenCvUtils.find(strictness, robot, OpenCvUtils.toMat(source.captureGreyScale()), OpenCvUtils.read(bytes), resize);
        if (found == null) {
            return null;
        }
        return found.toAbsolute(source);
    }

    public static Region find(int strictness, RobotBase robot, Mat source, Mat target, boolean resize) {
        List<Region> found = OpenCvUtils.find(strictness, false, robot, source, target, resize);
        if (found.isEmpty()) {
            return null;
        }
        return found.get(0);
    }

    public static List<Region> findAll(int strictness, RobotBase robot, Region source, byte[] bytes, boolean resize) {
        List<Region> found = OpenCvUtils.find(strictness, true, robot, OpenCvUtils.toMat(source.captureGreyScale()), OpenCvUtils.read(bytes), resize);
        ArrayList<Region> list = new ArrayList<Region>(found.size());
        for (Region r : found) {
            list.add(r.toAbsolute(source));
        }
        return list;
    }

    public static Mat rescale(Mat mat, double scale) {
        Mat resized = new Mat();
        opencv_imgproc.resize((Mat)mat, (Mat)resized, (Size)new Size(), (double)scale, (double)scale, (int)3);
        return resized;
    }

    private static List<int[]> getPointsBelowThreshold(Mat src, double threshold) {
        Mat dst = new Mat();
        opencv_imgproc.threshold((Mat)src, (Mat)dst, (double)threshold, (double)1.0, (int)1);
        Mat non = new Mat();
        opencv_core.findNonZero((Mat)dst, (Mat)non);
        int len = (int)non.total();
        int xPrev = -5;
        int yPrev = -5;
        int countPrev = 0;
        int xSum = 0;
        int ySum = 0;
        ArrayList<int[]> points = new ArrayList<int[]>(len);
        for (int i = 0; i < len; ++i) {
            BytePointer ptr = non.ptr(i);
            Point p = new Point((Pointer)ptr);
            int x = p.x();
            int y = p.y();
            int xDelta = Math.abs(x - xPrev);
            int yDelta = Math.abs(y - yPrev);
            if (xDelta < 5 && yDelta < 5) {
                ++countPrev;
                xSum += x;
                ySum += y;
            } else {
                if (countPrev > 0) {
                    int xFinal = Math.floorDiv(xSum, countPrev);
                    int yFinal = Math.floorDiv(ySum, countPrev);
                    points.add(new int[]{xFinal, yFinal});
                }
                xSum = x;
                ySum = y;
                countPrev = 1;
            }
            xPrev = x;
            yPrev = y;
        }
        if (countPrev > 0) {
            int xFinal = Math.floorDiv(xSum, countPrev);
            int yFinal = Math.floorDiv(ySum, countPrev);
            points.add(new int[]{xFinal, yFinal});
        }
        return points;
    }

    private static Region toRegion(RobotBase robot, int[] p, double scale, int targetWidth, int targetHeight) {
        int x = (int)Math.round((double)p[0] / scale);
        int y = (int)Math.round((double)p[1] / scale);
        int width = (int)Math.round((double)targetWidth / scale);
        int height = (int)Math.round((double)targetHeight / scale);
        return new Region(robot, x, y, width, height);
    }

    private static int[] templateAndMin(int strictness, double scale, Mat source, Mat target, Mat result) {
        Mat resized = scale == 1.0 ? source : OpenCvUtils.rescale(source, scale);
        opencv_imgproc.matchTemplate((Mat)resized, (Mat)target, (Mat)result, (int)0);
        DoublePointer minValPtr = new DoublePointer(1L);
        DoublePointer maxValPtr = new DoublePointer(1L);
        Point minPt = new Point();
        Point maxPt = new Point();
        opencv_core.minMaxLoc((Mat)result, (DoublePointer)minValPtr, (DoublePointer)maxValPtr, (Point)minPt, (Point)maxPt, null);
        int minVal = (int)minValPtr.get();
        int x = minPt.x();
        int y = minPt.y();
        return new int[]{x, y, minVal};
    }

    private static int collect(int strictness, List<Region> found, boolean findAll, RobotBase robot, Mat source, Mat target, double scale) {
        int targetWidth = target.cols();
        int targetHeight = target.rows();
        int targetMinVal = targetWidth * targetHeight * 150 * strictness;
        Mat result = new Mat();
        int[] minData = OpenCvUtils.templateAndMin(strictness, scale, source, target, result);
        int minValue = minData[2];
        if (minValue > targetMinVal) {
            logger.debug("no match at scale {}, minVal: {} / {} at {}:{}", new Object[]{scale, minValue, targetMinVal, minData[0], minData[1]});
            if (robot != null && robot.debug) {
                Rect rect = new Rect(minData[0], minData[1], targetWidth, targetHeight);
                Mat temp = OpenCvUtils.drawOnImage(source, rect, Scalar.RED);
                OpenCvUtils.show(temp, scale + " " + minData[0] + ":" + minData[1] + " " + minValue + " / " + targetMinVal);
            }
            return minData[2];
        }
        logger.debug("found match at scale {}, minVal: {} / {} at {}:{}", new Object[]{scale, minValue, targetMinVal, minData[0], minData[1]});
        if (findAll) {
            List<int[]> points = OpenCvUtils.getPointsBelowThreshold(result, targetMinVal);
            for (int[] p : points) {
                Region region = OpenCvUtils.toRegion(robot, p, scale, targetWidth, targetHeight);
                found.add(region);
            }
        } else {
            Region region = OpenCvUtils.toRegion(robot, minData, scale, targetWidth, targetHeight);
            found.add(region);
        }
        return minValue;
    }

    public static List<Region> find(int strictness, boolean findAll, RobotBase robot, Mat source, Mat target, boolean resize) {
        double scale;
        int step;
        ArrayList<Region> found = new ArrayList<Region>();
        OpenCvUtils.collect(strictness, found, findAll, robot, source, target, 1.0);
        if (!found.isEmpty()) {
            return found;
        }
        int stepUp = OpenCvUtils.collect(strictness, found, findAll, robot, source, target, 1.1);
        if (!found.isEmpty()) {
            return found;
        }
        int stepDown = OpenCvUtils.collect(strictness, found, findAll, robot, source, target, 0.9);
        if (!found.isEmpty()) {
            return found;
        }
        boolean goUpFirst = stepUp < stepDown;
        for (step = 2; step < 6; ++step) {
            scale = 1.0 + 0.1 * (double)step * (double)(goUpFirst ? 1 : -1);
            OpenCvUtils.collect(strictness, found, findAll, robot, source, target, scale);
        }
        if (!findAll && !found.isEmpty()) {
            return found;
        }
        for (step = 2; step < 6; ++step) {
            scale = 1.0 + 0.1 * (double)step * (double)(goUpFirst ? -1 : 1);
            OpenCvUtils.collect(strictness, found, findAll, robot, source, target, scale);
        }
        return found;
    }

    public static Mat loadAndShowOrExit(File file, int flags) {
        Mat image = OpenCvUtils.read(file, flags);
        OpenCvUtils.show(image, file.getName());
        return image;
    }

    public static BufferedImage readImageAsGreyScale(File file) {
        Mat mat = OpenCvUtils.read(file, 0);
        return OpenCvUtils.toBufferedImage(mat);
    }

    public static byte[] toBytes(BufferedImage img) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Mat read(File file) {
        return OpenCvUtils.read(file, 0);
    }

    public static Mat read(byte[] bytes) {
        return OpenCvUtils.read(bytes, 0);
    }

    public static Mat read(byte[] bytes, int flags) {
        Mat image = opencv_imgcodecs.imdecode((Mat)new Mat(bytes), (int)flags);
        if (image.empty()) {
            throw new RuntimeException("image decode failed");
        }
        return image;
    }

    public static Mat read(File file, int flags) {
        Mat image = opencv_imgcodecs.imread((String)file.getAbsolutePath(), (int)flags);
        if (image.empty()) {
            throw new RuntimeException("image not found: " + file.getAbsolutePath());
        }
        return image;
    }

    public static File save(BufferedImage image, File file) {
        try {
            ImageIO.write((RenderedImage)image, "png", file);
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void show(byte[] bytes, String title) {
        Mat mat = OpenCvUtils.read(bytes);
        OpenCvUtils.show(OpenCvUtils.toBufferedImage(mat), title);
    }

    public static void show(Mat mat, String title) {
        OpenCvUtils.show(OpenCvUtils.toBufferedImage(mat), title);
    }

    public static void show(Image image, String title) {
        CanvasFrame canvas = new CanvasFrame(title, 1.0);
        canvas.setDefaultCloseOperation(2);
        canvas.showImage(image);
    }

    public static void save(Mat image, File file) {
        opencv_imgcodecs.imwrite((String)file.getAbsolutePath(), (Mat)image);
    }

    public static Mat drawOnImage(Mat image, Point2fVector points) {
        Mat dest = image.clone();
        int radius = 5;
        Scalar red = new Scalar(0.0, 0.0, 255.0, 0.0);
        int i = 0;
        while ((long)i < points.size()) {
            Point2f p = points.get((long)i);
            opencv_imgproc.circle((Mat)dest, (Point)new Point(Math.round(p.x()), Math.round(p.y())), (int)radius, (Scalar)red);
            ++i;
        }
        return dest;
    }

    public static Mat drawOnImage(Mat image, Rect overlay, Scalar color) {
        Mat dest = image.clone();
        opencv_imgproc.rectangle((Mat)dest, (Rect)overlay, (Scalar)color);
        return dest;
    }

    public static Mat negative(Mat src) {
        Mat dest = new Mat();
        opencv_core.bitwise_not((Mat)src, (Mat)dest);
        return dest;
    }

    public static Mat toMat(BufferedImage bi) {
        return Java2DFrameUtils.toMat((BufferedImage)bi);
    }

    public static BufferedImage toBufferedImage(Mat mat) {
        OpenCVFrameConverter.ToMat openCVConverter = new OpenCVFrameConverter.ToMat();
        Java2DFrameConverter java2DConverter = new Java2DFrameConverter();
        return java2DConverter.convert(openCVConverter.convert(mat));
    }
}

