/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot;

import com.intuit.karate.robot.Location;
import com.intuit.karate.robot.OpenCvUtils;
import com.intuit.karate.robot.RobotBase;
import com.intuit.karate.robot.RobotUtils;
import com.intuit.karate.robot.Tesseract;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class Region {
    public final RobotBase robot;
    public final int x;
    public final int y;
    public final int width;
    public final int height;

    Region toAbsolute(Region offset) {
        return new Region(this.robot, this.x + offset.x, this.y + offset.y, this.width, this.height);
    }

    public Region(RobotBase robot, int x, int y) {
        this(robot, x, y, 0, 0);
    }

    public Region(RobotBase robot, int x, int y, int width, int height) {
        this.robot = robot;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    private BufferedImage capture(int type) {
        BufferedImage image = this.robot.robot.createScreenCapture(new Rectangle(this.x, this.y, this.width, this.height));
        BufferedImage bi = new BufferedImage(this.width, this.height, type);
        Graphics2D g = bi.createGraphics();
        g.drawImage(image, 0, 0, this.width, this.height, null);
        return bi;
    }

    public BufferedImage capture() {
        return this.capture(1);
    }

    public BufferedImage captureGreyScale() {
        return this.capture(10);
    }

    public Location getCenter() {
        return new Location(this.robot, this.x + this.width / 2, this.y + this.height / 2);
    }

    public Location inset(int deltaX, int deltaY) {
        return new Location(this.robot, this.x + deltaX, this.y + deltaY);
    }

    public void highlight() {
        this.highlight(3000);
    }

    public void highlight(int millis) {
        RobotUtils.highlight(this, millis);
    }

    public Region click() {
        return this.click(1);
    }

    public Region click(int num) {
        this.getCenter().click(num);
        return this;
    }

    public Region move() {
        this.getCenter().move();
        return this;
    }

    public Region press() {
        this.getCenter().press();
        return this;
    }

    public Region release() {
        this.getCenter().release();
        return this;
    }

    public Map<String, Object> getPosition() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("x", this.x);
        map.put("y", this.y);
        map.put("width", this.width);
        map.put("height", this.height);
        return map;
    }

    public byte[] screenshot() {
        return this.robot.screenshot(this);
    }

    public String extract(String lang, boolean debug) {
        boolean negative;
        if (lang == null) {
            lang = this.robot.tessLang;
        }
        if (((String)lang).length() < 2) {
            lang = (String)lang + this.robot.tessLang;
        }
        boolean bl = negative = ((String)lang).charAt(0) == '-';
        if (negative) {
            lang = ((String)lang).substring(1);
        }
        Tesseract tess = Tesseract.init(this.robot, (String)lang, this, negative);
        if (debug) {
            tess.highlightWords(this.robot, this, 3000);
        }
        return tess.getAllText();
    }

    public void debugCapture() {
        OpenCvUtils.show(this.capture(), this.toString());
    }

    public String debugExtract() {
        return this.extract(null, true);
    }

    public String debugExtract(String lang) {
        return this.extract(lang, true);
    }

    public String toString() {
        return this.x + ":" + this.y + "(" + this.width + ":" + this.height + ")";
    }
}

