/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot;

import com.intuit.karate.KarateException;
import com.intuit.karate.Logger;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Plugin;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.core.Variable;
import com.intuit.karate.driver.Keys;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.robot.Element;
import com.intuit.karate.robot.ImageElement;
import com.intuit.karate.robot.Location;
import com.intuit.karate.robot.MissingElement;
import com.intuit.karate.robot.OpenCvUtils;
import com.intuit.karate.robot.Region;
import com.intuit.karate.robot.Robot;
import com.intuit.karate.robot.RobotUtils;
import com.intuit.karate.robot.StringMatcher;
import com.intuit.karate.robot.Tesseract;
import com.intuit.karate.shell.Command;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class RobotBase
implements Robot,
Plugin {
    private static final int CLICK_POST_DELAY = 500;
    public final java.awt.Robot robot;
    public final Toolkit toolkit;
    public final Dimension dimension;
    public final Map<String, Object> options;
    public final boolean autoClose;
    public final boolean screenshotOnFailure;
    public final int autoDelay;
    public final Region screen;
    public final String tessData;
    public final String tessLang;
    private String basePath;
    protected Command command;
    protected ScenarioEngine engine;
    protected Logger logger;
    protected Element currentWindow;
    private boolean retryEnabled;
    private Integer retryIntervalOverride = null;
    private Integer retryCountOverride = null;
    protected boolean debug;
    public boolean highlight;
    public int highlightDuration;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    public void setHighlightDuration(int highlightDuration) {
        this.highlightDuration = highlightDuration;
    }

    public void disableRetry() {
        this.retryEnabled = false;
        this.retryCountOverride = null;
        this.retryIntervalOverride = null;
    }

    public void enableRetry(Integer count, Integer interval) {
        this.retryEnabled = true;
        this.retryCountOverride = count;
        this.retryIntervalOverride = interval;
    }

    private int getRetryCount() {
        return this.retryCountOverride == null ? this.engine.getConfig().getRetryCount() : this.retryCountOverride.intValue();
    }

    private int getRetryInterval() {
        return this.retryIntervalOverride == null ? this.engine.getConfig().getRetryInterval() : this.retryIntervalOverride.intValue();
    }

    private <T> T get(String key, T defaultValue) {
        Object temp = this.options.get(key);
        return (T)(temp == null ? defaultValue : temp);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public RobotBase(ScenarioRuntime runtime) {
        this(runtime, Collections.EMPTY_MAP);
    }

    public RobotBase(ScenarioRuntime runtime, Map<String, Object> options) {
        this.engine = runtime.engine;
        this.logger = runtime.logger;
        try {
            this.options = options;
            this.basePath = this.get("basePath", null);
            this.highlight = this.get("highlight", false);
            this.highlightDuration = this.get("highlightDuration", 3000);
            this.autoDelay = this.get("autoDelay", 0);
            this.tessData = this.get("tessData", "tessdata");
            this.tessLang = this.get("tessLang", "eng");
            this.toolkit = Toolkit.getDefaultToolkit();
            this.dimension = this.toolkit.getScreenSize();
            this.screen = new Region(this, 0, 0, this.dimension.width, this.dimension.height);
            this.logger.debug("screen dimensions: {}", new Object[]{this.screen});
            this.robot = new java.awt.Robot();
            this.robot.setAutoDelay(this.autoDelay);
            this.robot.setAutoWaitForIdle(true);
            this.screenshotOnFailure = this.get("screenshotOnFailure", true);
            this.autoClose = this.get("autoClose", true);
            boolean attach = this.get("attach", true);
            String window = this.get("window", null);
            if (window != null) {
                this.currentWindow = this.window(window, false, false);
            }
            if (this.currentWindow != null && attach) {
                this.logger.debug("window found, will re-use: {}", new Object[]{window});
            } else {
                Variable v = new Variable(options.get("fork"));
                if (v.isString()) {
                    this.command = this.engine.fork(true, v.getAsString());
                } else if (v.isList()) {
                    this.command = this.engine.fork(true, (List)v.getValue());
                } else if (v.isMap()) {
                    this.command = this.engine.fork(true, (Map)v.getValue());
                }
                if (this.command != null) {
                    this.delay(500);
                    if (this.command.isFailed()) {
                        throw new KarateException("robot fork command failed: " + this.command.getFailureReason().getMessage());
                    }
                    if (window != null) {
                        this.retryCountOverride = this.get("retryCount", null);
                        this.retryIntervalOverride = this.get("retryInterval", null);
                        this.currentWindow = this.window(window);
                        this.logger.debug("attached to process window: {} - {}", new Object[]{this.currentWindow, this.command.getArgList()});
                    }
                }
                if (this.currentWindow == null && window != null) {
                    throw new KarateException("failed to find window: " + window);
                }
            }
        }
        catch (Exception e) {
            String message = "robot init failed: " + e.getMessage();
            throw new KarateException(message, (Throwable)e);
        }
    }

    public <T> T retry(Supplier<T> action, Predicate<T> condition, String logDescription, boolean failWithException) {
        T result;
        boolean success;
        long startTime = System.currentTimeMillis();
        int count = 0;
        int max = this.getRetryCount();
        int interval = this.getRetryInterval();
        this.disableRetry();
        do {
            if (count <= 0) continue;
            this.logger.debug("{} - retry #{}", new Object[]{logDescription, count});
            this.delay(interval);
        } while (!(success = condition.test(result = action.get())) && count++ < max);
        if (!success) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            String message = logDescription + ": failed after " + (count - 1) + " retries and " + elapsedTime + " milliseconds";
            this.logger.warn(message, new Object[0]);
            if (failWithException) {
                throw new RuntimeException(message);
            }
        }
        return result;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private byte[] readBytes(String path) {
        if (this.basePath != null) {
            String slash = this.basePath.endsWith(":") ? "" : "/";
            path = this.basePath + slash + (String)path;
        }
        return this.engine.fileReader.readFileAsBytes((String)path);
    }

    public void onFailure(StepResult stepResult) {
        if (this.screenshotOnFailure && !stepResult.isWithCallResults()) {
            byte[] byArray = this.screenshot();
        }
    }

    @Override
    public Robot retry() {
        return this.retry(null, null);
    }

    @Override
    public Robot retry(int count) {
        return this.retry(count, null);
    }

    @Override
    public Robot retry(Integer count, Integer interval) {
        this.enableRetry(count, interval);
        return this;
    }

    @Override
    public Robot delay(int millis) {
        this.robot.delay(millis);
        return this;
    }

    private static int mask(int num) {
        switch (num) {
            case 2: {
                return 2048;
            }
            case 3: {
                return 4096;
            }
        }
        return 1024;
    }

    @Override
    public Robot click() {
        return this.click(1);
    }

    @Override
    public Robot rightClick() {
        return this.click(3);
    }

    @Override
    public Robot click(int num) {
        int mask = RobotBase.mask(num);
        this.robot.mousePress(mask);
        if (this.highlight) {
            this.getLocation().highlight(this.highlightDuration);
            int toDelay = 500 - this.highlightDuration;
            if (toDelay > 0) {
                RobotUtils.delay(toDelay);
            }
        } else {
            RobotUtils.delay(500);
        }
        this.robot.mouseRelease(mask);
        return this;
    }

    @Override
    public Robot doubleClick() {
        this.click();
        this.delay(40);
        this.click();
        return this;
    }

    @Override
    public Robot press() {
        int mask = RobotBase.mask(1);
        this.robot.mousePress(mask);
        return this;
    }

    @Override
    public Robot release() {
        int mask = RobotBase.mask(1);
        this.robot.mouseRelease(mask);
        return this;
    }

    @Override
    public Robot input(String[] values) {
        return this.input(values, 0);
    }

    @Override
    public Robot input(String chars, int delay) {
        String[] array = new String[chars.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Character.toString(chars.charAt(i));
        }
        return this.input(array, delay);
    }

    @Override
    public Robot input(String[] values, int delay) {
        for (String s : values) {
            if (delay > 0) {
                this.delay(delay);
            }
            this.input(s);
        }
        return this;
    }

    @Override
    public Robot input(String value) {
        int[] codes;
        if (this.highlight) {
            this.getFocused().highlight(this.highlightDuration);
        }
        StringBuilder sb = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (Keys.isModifier((char)c)) {
                sb.append(c);
                codes = RobotUtils.KEY_CODES.get(Character.valueOf(c));
                if (codes == null) {
                    this.logger.warn("cannot resolve char: {}", new Object[]{Character.valueOf(c)});
                    this.robot.keyPress(c);
                    continue;
                }
                this.robot.keyPress(codes[0]);
                continue;
            }
            codes = RobotUtils.KEY_CODES.get(Character.valueOf(c));
            if (codes == null) {
                this.logger.warn("cannot resolve char: {}", new Object[]{Character.valueOf(c)});
                this.robot.keyPress(c);
                this.robot.keyRelease(c);
                continue;
            }
            if (codes.length > 1) {
                this.robot.keyPress(codes[0]);
                this.robot.keyPress(codes[1]);
                this.robot.keyRelease(codes[1]);
                this.robot.keyRelease(codes[0]);
                continue;
            }
            this.robot.keyPress(codes[0]);
            this.robot.keyRelease(codes[0]);
        }
        for (char c : sb.toString().toCharArray()) {
            codes = RobotUtils.KEY_CODES.get(Character.valueOf(c));
            if (codes == null) {
                this.logger.warn("cannot resolve char: {}", new Object[]{Character.valueOf(c)});
                this.robot.keyRelease(c);
                continue;
            }
            this.robot.keyRelease(codes[0]);
        }
        return this;
    }

    public Robot clearFocused() {
        return this.input("\ue009a\ue017");
    }

    protected int getHighlightDuration() {
        return this.highlight ? this.highlightDuration : -1;
    }

    @Override
    public Element input(String locator, String value) {
        return this.locate(locator).input(value);
    }

    @Override
    public byte[] screenshot() {
        return this.screenshot(this.screen);
    }

    @Override
    public byte[] screenshotActive() {
        return this.getActive().screenshot();
    }

    public byte[] screenshot(int x, int y, int width, int height) {
        return this.screenshot(new Region(this, x, y, width, height));
    }

    public byte[] screenshot(Region region) {
        BufferedImage image = region.capture();
        byte[] bytes = OpenCvUtils.toBytes(image);
        this.getRuntime().embed(bytes, ResourceType.PNG);
        return bytes;
    }

    @Override
    public Robot move(int x, int y) {
        this.robot.mouseMove(x, y);
        return this;
    }

    @Override
    public Robot click(int x, int y) {
        return this.move(x, y).click();
    }

    @Override
    public Element highlight(String locator) {
        return this.locate(3000, this.getSearchRoot(), locator);
    }

    @Override
    public List<Element> highlightAll(String locator) {
        return this.locateAll(3000, this.getSearchRoot(), locator);
    }

    @Override
    public Element focus(String locator) {
        return this.locate(this.getHighlightDuration(), this.getSearchRoot(), locator).focus();
    }

    @Override
    public Element locate(String locator) {
        return this.locate(this.getHighlightDuration(), this.getSearchRoot(), locator);
    }

    @Override
    public List<Element> locateAll(String locator) {
        return this.locateAll(this.getHighlightDuration(), this.getSearchRoot(), locator);
    }

    @Override
    public boolean exists(String locator) {
        return this.optional(locator).isPresent();
    }

    @Override
    public Element optional(String locator) {
        return this.optional(this.getSearchRoot(), locator);
    }

    @Override
    public boolean windowExists(String locator) {
        return this.windowOptional(locator).isPresent();
    }

    @Override
    public Element windowOptional(String locator) {
        return this.waitForWindowOptional(locator, false);
    }

    @Override
    public Element waitForWindowOptional(String locator) {
        return this.waitForWindowOptional(locator, true);
    }

    protected Element waitForWindowOptional(String locator, boolean retry) {
        Element prevWindow = this.currentWindow;
        Element window = this.window(locator, retry, false);
        this.currentWindow = prevWindow;
        if (window == null) {
            return new MissingElement(this);
        }
        return window;
    }

    protected Element optional(Element searchRoot, String locator) {
        Element found = this.locateImageOrElement(searchRoot, locator);
        if (found == null) {
            this.logger.warn("element does not exist: {}", new Object[]{locator});
            return new MissingElement(this);
        }
        if (this.highlight) {
            found.highlight();
        }
        return found;
    }

    protected Element locate(int duration, Element searchRoot, String locator) {
        Element found;
        if (this.retryEnabled) {
            found = this.retryForAny(true, searchRoot, locator);
        } else {
            found = this.locateImageOrElement(searchRoot, locator);
            if (found == null) {
                String message = "cannot locate: '" + locator + "' (" + searchRoot.getDebugString() + ")";
                this.logger.error(message, new Object[0]);
                throw new RuntimeException(message);
            }
            if (duration > 0) {
                found.getRegion().highlight(duration);
            }
        }
        return found;
    }

    protected List<Element> locateAll(int duration, Element searchRoot, String locator) {
        List<Element> found = locator.endsWith(".png") ? this.locateAllImages(searchRoot, locator) : (locator.startsWith("{") ? this.locateAllText(searchRoot, locator) : this.locateAllInternal(searchRoot, locator));
        if (duration > 0) {
            RobotUtils.highlightAll(searchRoot.getRegion(), found, duration, false);
        }
        return found;
    }

    @Override
    public Element move(String locator) {
        return this.locate(this.getHighlightDuration(), this.getSearchRoot(), locator).move();
    }

    @Override
    public Element click(String locator) {
        return this.locate(this.getHighlightDuration(), this.getSearchRoot(), locator).click();
    }

    @Override
    public Element select(String locator) {
        return this.locate(this.getHighlightDuration(), this.getSearchRoot(), locator).select();
    }

    @Override
    public Element press(String locator) {
        return this.locate(this.getHighlightDuration(), this.getSearchRoot(), locator).press();
    }

    @Override
    public Element release(String locator) {
        return this.locate(this.getHighlightDuration(), this.getSearchRoot(), locator).release();
    }

    private StringUtils.Pair parseOcr(String raw) {
        int pos = raw.indexOf(125);
        Object lang = raw.substring(1, pos);
        if (((String)lang).length() < 2) {
            lang = (String)lang + this.tessLang;
        }
        String text = raw.substring(pos + 1);
        return StringUtils.pair((String)lang, (String)text);
    }

    public List<Element> locateAllText(Element searchRoot, String path) {
        boolean negative;
        StringUtils.Pair pair = this.parseOcr(path);
        String lang = pair.left;
        boolean bl = negative = lang.charAt(0) == '-';
        if (negative) {
            lang = lang.substring(1);
        }
        String text = pair.right;
        return Tesseract.findAll(this, lang, searchRoot.getRegion(), text, negative);
    }

    public Element locateText(Element searchRoot, String path) {
        boolean negative;
        StringUtils.Pair pair = this.parseOcr(path);
        String lang = pair.left;
        boolean bl = negative = lang.charAt(0) == '-';
        if (negative) {
            lang = lang.substring(1);
        }
        String text = pair.right;
        return Tesseract.find(this, lang, searchRoot.getRegion(), text, negative);
    }

    public List<Element> locateAllImages(Element searchRoot, String path) {
        PathAndStrict ps = new PathAndStrict(path);
        List<Region> found = OpenCvUtils.findAll(ps.strictness, this, searchRoot.getRegion(), this.readBytes(ps.path), true);
        ArrayList<Element> list = new ArrayList<Element>(found.size());
        for (Region region : found) {
            list.add(new ImageElement(region));
        }
        return list;
    }

    public Element locateImage(Region region, String path) {
        PathAndStrict ps = new PathAndStrict(path);
        return this.locateImage(region, ps.strictness, this.readBytes(ps.path));
    }

    public Element locateImage(Region searchRegion, int strictness, byte[] bytes) {
        Region region = OpenCvUtils.find(strictness, this, searchRegion, bytes, true);
        if (region == null) {
            return null;
        }
        return new ImageElement(region);
    }

    @Override
    public Element window(String title) {
        return this.window(title, true, true);
    }

    private Element window(String title, boolean retry, boolean failWithException) {
        return this.window(new StringMatcher(title), retry, failWithException);
    }

    @Override
    public Element window(Predicate<String> condition) {
        return this.window(condition, true, true);
    }

    private Element window(Predicate<String> condition, boolean retry, boolean failWithException) {
        try {
            this.currentWindow = retry ? this.retry(() -> this.windowInternal(condition), w -> w != null, "find window", failWithException) : this.windowInternal(condition);
        }
        catch (Exception e) {
            if (failWithException) {
                throw e;
            }
            this.logger.warn("failed to find window: {}", new Object[]{e.getMessage()});
            this.currentWindow = null;
        }
        if (this.currentWindow != null && this.highlight) {
            this.currentWindow.highlight(this.getHighlightDuration());
        }
        return this.currentWindow;
    }

    protected Element getSearchRoot() {
        if (this.currentWindow == null) {
            this.logger.warn("using desktop as search root, activate a window or parent element for better performance", new Object[0]);
            return this.getRoot();
        }
        return this.currentWindow;
    }

    @Override
    public Object waitUntil(Supplier<Object> condition) {
        return this.waitUntil(condition, true);
    }

    @Override
    public Object waitUntilOptional(Supplier<Object> condition) {
        return this.waitUntil(condition, false);
    }

    protected Object waitUntil(Supplier<Object> condition, boolean failWithException) {
        return this.retry(() -> condition.get(), o -> o != null, "waitUntil (function)", failWithException);
    }

    @Override
    public Element waitFor(String locator) {
        return this.retryForAny(true, this.getSearchRoot(), locator);
    }

    @Override
    public Element waitForOptional(String locator) {
        return this.retryForAny(false, this.getSearchRoot(), locator);
    }

    @Override
    public Element waitForAny(String locator1, String locator2) {
        return this.retryForAny(true, this.getSearchRoot(), locator1, locator2);
    }

    @Override
    public Element waitForAny(String[] locators) {
        return this.retryForAny(true, this.getSearchRoot(), locators);
    }

    protected Element retryForAny(boolean failWithException, Element searchRoot, String ... locators) {
        Element found = this.retry(() -> this.waitForAny(searchRoot, locators), r -> r != null, "find by locator(s): " + Arrays.asList(locators), failWithException);
        return found == null ? new MissingElement(this) : found;
    }

    private Element waitForAny(Element searchRoot, String ... locators) {
        for (String locator : locators) {
            Element found = this.locateImageOrElement(searchRoot, locator);
            if (found == null) continue;
            if (this.highlight) {
                found.getRegion().highlight(this.highlightDuration);
            }
            return found;
        }
        return null;
    }

    private Element locateImageOrElement(Element searchRoot, String locator) {
        if (locator.endsWith(".png")) {
            return this.locateImage(searchRoot.getRegion(), locator);
        }
        if (locator.startsWith("{")) {
            return this.locateText(searchRoot, locator);
        }
        if (searchRoot.isImage()) {
            throw new RuntimeException("todo find non-image elements within region");
        }
        return this.locateInternal(searchRoot, locator);
    }

    @Override
    public Element activate(String locator) {
        return this.locate(locator).activate();
    }

    @Override
    public Element getActive() {
        if (this.currentWindow == null) {
            throw new RuntimeException("no window has been selected or activated");
        }
        return this.currentWindow;
    }

    @Override
    public Robot setActive(Element e) {
        if (e.isPresent()) {
            this.currentWindow = e;
        }
        return this;
    }

    public void debugImage(String path) {
        byte[] bytes = this.readBytes(path);
        OpenCvUtils.show(bytes, path);
    }

    @Override
    public String getClipboard() {
        try {
            return (String)this.toolkit.getSystemClipboard().getData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            this.logger.warn("unable to return clipboard as string: {}", new Object[]{e.getMessage()});
            return null;
        }
    }

    @Override
    public Location getLocation() {
        Point p = MouseInfo.getPointerInfo().getLocation();
        return new Location(this, p.x, p.y);
    }

    public Location location(int x, int y) {
        return new Location(this, x, y);
    }

    public Region region(Map<String, Integer> map) {
        return new Region(this, map.get("x"), map.get("y"), map.get("width"), map.get("height"));
    }

    @Override
    public abstract Element getRoot();

    @Override
    public abstract Element getFocused();

    protected abstract Element windowInternal(String var1);

    protected abstract Element windowInternal(Predicate<String> var1);

    protected abstract Element locateInternal(Element var1, String var2);

    protected abstract List<Element> locateAllInternal(Element var1, String var2);

    private static class PathAndStrict {
        final int strictness;
        final String path;

        public PathAndStrict(String path) {
            int pos = path.indexOf(58);
            if (pos > 0 && pos < 3) {
                this.strictness = Integer.valueOf(path.substring(0, pos));
                this.path = path.substring(pos + 1);
            } else {
                this.strictness = 10;
                this.path = path;
            }
        }
    }
}

