/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot;

import com.intuit.karate.FileUtils;
import com.intuit.karate.core.PluginFactory;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.robot.Robot;
import com.intuit.karate.robot.linux.LinuxRobot;
import com.intuit.karate.robot.mac.MacRobot;
import com.intuit.karate.robot.win.WinRobot;
import java.util.HashMap;
import java.util.Map;

public class RobotFactory
implements PluginFactory {
    private static final FileUtils.OsType OS_TYPE = FileUtils.getOsType();

    public Robot create(ScenarioRuntime runtime, Map<String, Object> options) {
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        switch (OS_TYPE) {
            case LINUX: {
                return new LinuxRobot(runtime, options);
            }
            case MACOSX: {
                return new MacRobot(runtime, options);
            }
            case WINDOWS: {
                return new WinRobot(runtime, options);
            }
        }
        throw new RuntimeException("os not supported: " + OS_TYPE);
    }
}

