/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot;

import com.intuit.karate.robot.Element;
import com.intuit.karate.robot.OpenCvUtils;
import com.intuit.karate.robot.Region;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RobotUtils {
    private static final Logger logger = LoggerFactory.getLogger(RobotUtils.class);
    public static final Map<Character, int[]> KEY_CODES = new HashMap<Character, int[]>();

    public static void highlight(Region region, int time) {
        JFrame f = new JFrame();
        f.setUndecorated(true);
        f.setBackground(new Color(0, 0, 0, 0));
        f.setAlwaysOnTop(true);
        f.setDefaultCloseOperation(3);
        f.setType(Window.Type.UTILITY);
        f.setFocusableWindowState(false);
        f.setAutoRequestFocus(false);
        f.setLocation(region.x, region.y);
        f.setSize(region.width, region.height);
        f.getRootPane().setBorder(BorderFactory.createLineBorder(Color.RED, 3));
        f.setVisible(true);
        RobotUtils.delay(time);
        f.dispose();
    }

    public static void highlightAll(Region parent, List<Element> elements, int time, final boolean showValue) {
        JFrame f = new JFrame();
        f.setUndecorated(true);
        f.setBackground(new Color(0, 0, 0, 0));
        f.setAlwaysOnTop(true);
        f.setDefaultCloseOperation(3);
        f.setType(Window.Type.UTILITY);
        f.setFocusableWindowState(false);
        f.setAutoRequestFocus(false);
        f.setLocation(parent.x, parent.y);
        f.setSize(parent.width, parent.height);
        f.getRootPane().setBorder(BorderFactory.createLineBorder(Color.YELLOW, 3));
        final ArrayList<RegionBox> boxes = new ArrayList<RegionBox>(elements.size());
        for (Element e : elements) {
            Region region = e.getRegion();
            int x = region.x - parent.x;
            int y = region.y - parent.y;
            if (x <= 0 || y <= 0 || region.width <= 0 || region.height <= 0) continue;
            boxes.add(new RegionBox(x, y, region.width, region.height, showValue ? e.getValue() : null));
        }
        f.add(new JComponent(){

            @Override
            public void paint(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setStroke(new BasicStroke(2.0f));
                for (RegionBox box : boxes) {
                    g.setColor(Color.RED);
                    g.drawRect(box.x, box.y, box.width, box.height);
                    if (!showValue) continue;
                    String text = box.text;
                    FontMetrics fm = g.getFontMetrics();
                    Rectangle2D rect = fm.getStringBounds(text, g);
                    g.setColor(Color.BLACK);
                    g.fillRect(box.x, box.y - fm.getAscent(), (int)rect.getWidth(), (int)rect.getHeight());
                    g.setColor(Color.YELLOW);
                    g.drawString(box.text, box.x, box.y);
                }
            }
        });
        f.setVisible(true);
        RobotUtils.delay(time);
        if (showValue) {
            BufferedImage image = new BufferedImage(f.getWidth(), f.getHeight(), 1);
            f.paint(image.getGraphics());
            OpenCvUtils.show(image, parent.toString());
        }
        f.dispose();
    }

    public static void delay(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void key(char c, int ... i) {
        KEY_CODES.put(Character.valueOf(c), i);
    }

    static {
        RobotUtils.key('a', 65);
        RobotUtils.key('b', 66);
        RobotUtils.key('c', 67);
        RobotUtils.key('d', 68);
        RobotUtils.key('e', 69);
        RobotUtils.key('f', 70);
        RobotUtils.key('g', 71);
        RobotUtils.key('h', 72);
        RobotUtils.key('i', 73);
        RobotUtils.key('j', 74);
        RobotUtils.key('k', 75);
        RobotUtils.key('l', 76);
        RobotUtils.key('m', 77);
        RobotUtils.key('n', 78);
        RobotUtils.key('o', 79);
        RobotUtils.key('p', 80);
        RobotUtils.key('q', 81);
        RobotUtils.key('r', 82);
        RobotUtils.key('s', 83);
        RobotUtils.key('t', 84);
        RobotUtils.key('u', 85);
        RobotUtils.key('v', 86);
        RobotUtils.key('w', 87);
        RobotUtils.key('x', 88);
        RobotUtils.key('y', 89);
        RobotUtils.key('z', 90);
        RobotUtils.key('A', 16, 65);
        RobotUtils.key('B', 16, 66);
        RobotUtils.key('C', 16, 67);
        RobotUtils.key('D', 16, 68);
        RobotUtils.key('E', 16, 69);
        RobotUtils.key('F', 16, 70);
        RobotUtils.key('G', 16, 71);
        RobotUtils.key('H', 16, 72);
        RobotUtils.key('I', 16, 73);
        RobotUtils.key('J', 16, 74);
        RobotUtils.key('K', 16, 75);
        RobotUtils.key('L', 16, 76);
        RobotUtils.key('M', 16, 77);
        RobotUtils.key('N', 16, 78);
        RobotUtils.key('O', 16, 79);
        RobotUtils.key('P', 16, 80);
        RobotUtils.key('Q', 16, 81);
        RobotUtils.key('R', 16, 82);
        RobotUtils.key('S', 16, 83);
        RobotUtils.key('T', 16, 84);
        RobotUtils.key('U', 16, 85);
        RobotUtils.key('V', 16, 86);
        RobotUtils.key('W', 16, 87);
        RobotUtils.key('X', 16, 88);
        RobotUtils.key('Y', 16, 89);
        RobotUtils.key('Z', 16, 90);
        RobotUtils.key('1', 49);
        RobotUtils.key('2', 50);
        RobotUtils.key('3', 51);
        RobotUtils.key('4', 52);
        RobotUtils.key('5', 53);
        RobotUtils.key('6', 54);
        RobotUtils.key('7', 55);
        RobotUtils.key('8', 56);
        RobotUtils.key('9', 57);
        RobotUtils.key('0', 48);
        RobotUtils.key('!', 16, 49);
        RobotUtils.key('@', 16, 50);
        RobotUtils.key('#', 16, 51);
        RobotUtils.key('$', 16, 52);
        RobotUtils.key('%', 16, 53);
        RobotUtils.key('^', 16, 54);
        RobotUtils.key('&', 16, 55);
        RobotUtils.key('*', 16, 56);
        RobotUtils.key('(', 16, 57);
        RobotUtils.key(')', 16, 48);
        RobotUtils.key('`', 192);
        RobotUtils.key('~', 16, 192);
        RobotUtils.key('-', 45);
        RobotUtils.key('_', 16, 45);
        RobotUtils.key('=', 61);
        RobotUtils.key('+', 16, 61);
        RobotUtils.key('[', 91);
        RobotUtils.key('{', 16, 91);
        RobotUtils.key(']', 93);
        RobotUtils.key('}', 16, 93);
        RobotUtils.key('\\', 92);
        RobotUtils.key('|', 16, 92);
        RobotUtils.key(';', 59);
        RobotUtils.key(':', 16, 59);
        RobotUtils.key('\'', 222);
        RobotUtils.key('\"', 16, 222);
        RobotUtils.key(',', 44);
        RobotUtils.key('<', 16, 44);
        RobotUtils.key('.', 46);
        RobotUtils.key('|', 16, 46);
        RobotUtils.key('/', 47);
        RobotUtils.key('?', 16, 47);
        RobotUtils.key('\b', 8);
        RobotUtils.key('\t', 9);
        RobotUtils.key('\r', 10);
        RobotUtils.key('\n', 10);
        RobotUtils.key(' ', 32);
        RobotUtils.key('\ue009', 17);
        RobotUtils.key('\ue00a', 18);
        RobotUtils.key('\ue03d', 157);
        RobotUtils.key('\ue008', 16);
        RobotUtils.key('\ue004', 9);
        RobotUtils.key('\ue007', 10);
        RobotUtils.key('\ue00d', 32);
        RobotUtils.key('\ue003', 8);
        RobotUtils.key('\ue013', 38);
        RobotUtils.key('\ue014', 39);
        RobotUtils.key('\ue015', 40);
        RobotUtils.key('\ue012', 37);
        RobotUtils.key('\ue00e', 33);
        RobotUtils.key('\ue00f', 34);
        RobotUtils.key('\ue010', 35);
        RobotUtils.key('\ue011', 36);
        RobotUtils.key('\ue017', 127);
        RobotUtils.key('\ue00c', 27);
        RobotUtils.key('\ue031', 112);
        RobotUtils.key('\ue032', 113);
        RobotUtils.key('\ue033', 114);
        RobotUtils.key('\ue034', 115);
        RobotUtils.key('\ue035', 116);
        RobotUtils.key('\ue036', 117);
        RobotUtils.key('\ue037', 118);
        RobotUtils.key('\ue038', 119);
        RobotUtils.key('\ue039', 120);
        RobotUtils.key('\ue03a', 121);
        RobotUtils.key('\ue03b', 122);
        RobotUtils.key('\ue03c', 123);
        RobotUtils.key('\ue016', 155);
        RobotUtils.key('\ue00b', 19);
        RobotUtils.key('\ue01b', 97);
        RobotUtils.key('\ue01c', 98);
        RobotUtils.key('\ue01d', 99);
        RobotUtils.key('\ue01e', 100);
        RobotUtils.key('\ue01f', 101);
        RobotUtils.key('\ue020', 102);
        RobotUtils.key('\ue021', 103);
        RobotUtils.key('\ue022', 104);
        RobotUtils.key('\ue023', 105);
        RobotUtils.key('\ue01a', 96);
        RobotUtils.key('\ue026', 108);
        RobotUtils.key('\ue025', 107);
        RobotUtils.key('\ue027', 109);
        RobotUtils.key('\ue024', 106);
        RobotUtils.key('\ue029', 111);
        RobotUtils.key('\ue028', 110);
    }

    static class RegionBox {
        int x;
        int y;
        int width;
        int height;
        String text;

        RegionBox(int x, int y, int width, int height, String text) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.text = text;
        }
    }
}

