/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot;

import java.util.function.Predicate;
import java.util.regex.Pattern;

public class StringMatcher
implements Predicate<String> {
    private final String orig;
    private final String text;
    private final Predicate<String> pred;

    public StringMatcher(String raw) {
        this.orig = raw;
        if (raw.startsWith("^")) {
            this.text = raw.substring(1);
            this.pred = s -> s.contains(this.text);
        } else if (raw.startsWith("~")) {
            this.text = raw.substring(1);
            Pattern pattern = Pattern.compile(this.text);
            this.pred = s -> pattern.matcher((CharSequence)s).find();
        } else {
            this.text = raw;
            this.pred = s -> s.equals(this.text);
        }
    }

    @Override
    public boolean test(String t) {
        return this.pred.test(t);
    }

    public String toString() {
        return this.orig;
    }
}

