/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot;

import com.intuit.karate.robot.Element;
import com.intuit.karate.robot.ImageElement;
import com.intuit.karate.robot.OpenCvUtils;
import com.intuit.karate.robot.Region;
import com.intuit.karate.robot.RobotBase;
import com.intuit.karate.robot.RobotUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.tesseract.ResultIterator;
import org.bytedeco.tesseract.TessBaseAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tesseract {
    private static final Logger logger = LoggerFactory.getLogger(Tesseract.class);
    private final TessBaseAPI tess;
    private final Supplier<IntPointer> INT = () -> new IntPointer(new int[1]);
    private String allText;
    private List<Word> words;

    public String getAllText() {
        return this.allText;
    }

    public List<Word> getWords() {
        return this.words;
    }

    public Tesseract(File dataDir, String language) {
        this.tess = new TessBaseAPI();
        String dataPath = dataDir.getPath();
        if (this.tess.Init(dataPath, language) != 0) {
            throw new RuntimeException("tesseract init failed: " + dataDir.getAbsolutePath() + ", " + language);
        }
    }

    public static final Tesseract init(RobotBase robot, String lang, Region region, boolean negative) {
        File file = new File(robot.tessData);
        Tesseract tess = new Tesseract(file, lang);
        tess.process(region, negative);
        return tess;
    }

    public static Element find(RobotBase robot, String lang, Region sr, String text, boolean negative) {
        Tesseract tess = Tesseract.init(robot, lang, sr, negative);
        List<int[]> list = tess.find(false, text);
        if (list.isEmpty()) {
            return null;
        }
        int[] b = list.get(0);
        Region region = new Region(robot, sr.x + b[0], sr.y + b[1], b[2], b[3]);
        return new ImageElement(region);
    }

    public static List<Element> findAll(RobotBase robot, String lang, Region sr, String text, boolean negative) {
        Tesseract tess = Tesseract.init(robot, lang, sr, negative);
        List<int[]> list = tess.find(true, text);
        ArrayList<Element> found = new ArrayList<Element>(list.size());
        for (int[] b : list) {
            Region region = new Region(robot, sr.x + b[0], sr.y + b[1], b[2], b[3]);
            found.add(new ImageElement(region));
        }
        return found;
    }

    public void process(Region region, boolean negative) {
        BufferedImage bi = region.captureGreyScale();
        if (region.robot.highlight) {
            region.highlight(region.robot.highlightDuration);
        }
        Mat mat = OpenCvUtils.toMat(bi);
        this.process(mat, negative);
    }

    public void highlightWords(RobotBase robot, Region parent, int millis) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Word word : this.words) {
            Region region = new Region(robot, parent.x + word.x, parent.y + word.y, word.width, word.height);
            ImageElement e = new ImageElement(region, word.text);
            elements.add(e);
        }
        RobotUtils.highlightAll(parent, elements, millis, true);
    }

    public void process(Mat mat, boolean negative) {
        if (negative) {
            mat = OpenCvUtils.negative(mat);
        }
        int srcWidth = mat.size().width();
        int srcHeight = mat.size().height();
        int channels = mat.channels();
        int bytesPerLine = srcWidth * channels * (int)mat.elemSize1();
        this.tess.SetImage(mat.data().asBuffer(), srcWidth, srcHeight, channels, bytesPerLine);
        BytePointer textPtr = this.tess.GetUTF8Text();
        this.allText = textPtr.getString();
        textPtr.deallocate();
        ResultIterator ri = this.tess.GetIterator();
        int level = 3;
        this.words = new ArrayList<Word>();
        Word prev = null;
        do {
            float confidence;
            if ((confidence = ri.Confidence(level)) < 50.0f) continue;
            textPtr = ri.GetUTF8Text(level);
            String text = textPtr.getString().trim();
            textPtr.deallocate();
            IntPointer x1 = this.INT.get();
            IntPointer y1 = this.INT.get();
            IntPointer x2 = this.INT.get();
            IntPointer y2 = this.INT.get();
            boolean found = ri.BoundingBox(level, x1, y1, x2, y2);
            int x = x1.get();
            int y = y1.get();
            int width = x2.get() - x;
            int height = y2.get() - y;
            if (!found) {
                logger.warn("no such rectangle: {}:{}:{}:{}", new Object[]{x, y, width, height});
                continue;
            }
            Word word = new Word(prev, text, x, y, width, height, confidence);
            this.words.add(word);
            prev = word;
        } while (ri.Next(level));
    }

    public List<int[]> find(boolean findAll, String text) {
        StringTokenizer st = new StringTokenizer(text);
        String[] args = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            args[i] = st.nextToken();
            ++i;
        }
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (Word w : this.words) {
            boolean found = false;
            int i2 = 0;
            Word current = w;
            Word prev = null;
            do {
                String s = args[i2];
                found = s.contains(current.text);
                prev = current;
                current = current.next;
            } while (found && ++i2 < args.length && current != null);
            if (!found || i2 != args.length) continue;
            Word first = w;
            Word last = prev;
            int x = first.x;
            int y = first.y;
            int width = last.x + last.width - first.x;
            int height = Math.max(first.height, last.height);
            int[] bounds = new int[]{x, y, width, height};
            if (!findAll) {
                return Collections.singletonList(bounds);
            }
            list.add(bounds);
        }
        return list;
    }

    public static class Word {
        final String text;
        final int x;
        final int y;
        final int width;
        final int height;
        final float confidence;
        final Word prev;
        Word next;

        public Word(Word prev, String text, int x, int y, int width, int height, float confidence) {
            if (prev != null) {
                prev.next = this;
            }
            this.prev = prev;
            this.text = text;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.confidence = confidence;
        }

        public String toString() {
            return this.text + " " + this.x + ":" + this.y + "(" + this.width + ":" + this.height + ") " + this.confidence;
        }
    }
}

