/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot.linux;

import com.intuit.karate.StringUtils;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.robot.Element;
import com.intuit.karate.robot.ImageElement;
import com.intuit.karate.robot.RobotBase;
import com.intuit.karate.robot.Window;
import com.intuit.karate.shell.Command;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class LinuxRobot
extends RobotBase {
    public LinuxRobot(ScenarioRuntime runtime, Map<String, Object> options) {
        super(runtime, options);
    }

    public Map<String, Object> afterScenario() {
        return Collections.EMPTY_MAP;
    }

    @Override
    protected Element windowInternal(String title) {
        Command.exec((boolean)true, null, (String[])new String[]{"wmctrl", "-FR", title});
        return new ImageElement(this.screen);
    }

    @Override
    public Element windowInternal(Predicate<String> condition) {
        String res = Command.exec((boolean)true, null, (String[])new String[]{"wmctrl", "-l"});
        List lines = StringUtils.split((String)res, (char)'\n', (boolean)false);
        for (String line : lines) {
            List cols = StringUtils.split((String)line, (char)' ', (boolean)false);
            String id = (String)cols.get(0);
            String host = (String)cols.get(2);
            int pos = line.indexOf(host);
            String name = line.substring(pos + host.length() + 1);
            if (!condition.test(name)) continue;
            Command.exec((boolean)true, null, (String[])new String[]{"wmctrl", "-iR", id});
            return new ImageElement(this.screen);
        }
        return null;
    }

    @Override
    public List<Element> locateAllInternal(Element searchRoot, String locator) {
        throw new UnsupportedOperationException("not supported yet.");
    }

    @Override
    public Element locateInternal(Element root, String locator) {
        throw new UnsupportedOperationException("not supported yet.");
    }

    @Override
    public Element getRoot() {
        return new ImageElement(this.screen);
    }

    @Override
    public Element getFocused() {
        return new ImageElement(this.screen);
    }

    @Override
    public List<Window> getAllWindows() {
        throw new UnsupportedOperationException("not supported yet.");
    }
}

