/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot.mac;

import com.intuit.karate.StringUtils;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.robot.Element;
import com.intuit.karate.robot.ImageElement;
import com.intuit.karate.robot.RobotBase;
import com.intuit.karate.robot.Window;
import com.intuit.karate.shell.Command;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class MacRobot
extends RobotBase {
    private static final String MAC_GET_PROCS = "    tell application \"System Events\"\n    set procs to (processes whose background only is false)\n    set results to {}\n    repeat with n from 1 to the length of procs\n      set p to item n of procs\n      set entry to { name of p as text,\"|\"}\n      set end of results to entry\n    end repeat\n  end tell\n  results";

    public MacRobot(ScenarioRuntime runtime, Map<String, Object> options) {
        super(runtime, options);
    }

    public Map<String, Object> afterScenario() {
        return Collections.EMPTY_MAP;
    }

    public static List<String> getAppsMacOs() {
        Object res = Command.exec((boolean)true, null, (String[])new String[]{"osascript", "-e", MAC_GET_PROCS});
        res = (String)res + ", ";
        res = ((String)res).replace(", |, ", "\n");
        return StringUtils.split((String)res, (char)'\n', (boolean)false);
    }

    @Override
    public Element windowInternal(String title) {
        Command.exec((boolean)true, null, (String[])new String[]{"osascript", "-e", "tell app \"" + title + "\" to activate"});
        return new ImageElement(this.screen);
    }

    @Override
    public Element windowInternal(Predicate<String> condition) {
        List<String> list = MacRobot.getAppsMacOs();
        for (String s : list) {
            if (!condition.test(s)) continue;
            Command.exec((boolean)true, null, (String[])new String[]{"osascript", "-e", "tell app \"" + s + "\" to activate"});
            return new ImageElement(this.screen);
        }
        return null;
    }

    @Override
    public List<Element> locateAllInternal(Element searchRoot, String locator) {
        throw new UnsupportedOperationException("not supported yet.");
    }

    @Override
    public Element locateInternal(Element root, String locator) {
        throw new UnsupportedOperationException("not supported yet.");
    }

    @Override
    public Element getRoot() {
        return new ImageElement(this.screen);
    }

    @Override
    public Element getFocused() {
        return new ImageElement(this.screen);
    }

    @Override
    public List<Window> getAllWindows() {
        throw new UnsupportedOperationException("not supported yet.");
    }
}

