/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot.win;

import com.intuit.karate.robot.win.ComAllocated;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComAllocatedStr
implements ComAllocated {
    private static final Logger logger = LoggerFactory.getLogger(ComAllocatedStr.class);
    private final String value;
    private final WTypes.BSTR sysAllocated;

    public ComAllocatedStr(String value) {
        this.value = value;
        this.sysAllocated = OleAuto.INSTANCE.SysAllocString(value);
        if (logger.isTraceEnabled()) {
            logger.trace("allocated string: '{}'", (Object)value);
        }
    }

    @Override
    public Object value() {
        return this.sysAllocated;
    }

    @Override
    public void free() {
        OleAuto.INSTANCE.SysFreeString(this.sysAllocated);
        if (logger.isTraceEnabled()) {
            logger.trace("dellocated string: '{}'", (Object)this.value);
        }
    }
}

