/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot.win;

import com.intuit.karate.robot.win.ComFunction;
import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.util.LinkedHashMap;
import java.util.Map;

public class ComInterface {
    public final String name;
    public final String implementing;
    public final String guid;
    public final Map<String, ComFunction> functions = new LinkedHashMap<String, ComFunction>();

    public ComInterface(String name, String implementing, String guid) {
        this.name = name;
        this.implementing = implementing;
        this.guid = guid;
    }

    public void add(ComFunction function) {
        this.functions.put(function.name, function);
    }

    public Function getFunction(String functionName, Pointer p) {
        ComFunction cf = this.functions.get(functionName);
        if (cf == null) {
            throw new RuntimeException("no such function: " + functionName + " in: " + this.name);
        }
        Pointer tableRef = p.getPointer(0L);
        Pointer functionRef = tableRef.getPointer((long)cf.vtableId);
        return Function.getFunction((Pointer)functionRef, (int)63);
    }

    public Function getFunction(int offset, Pointer p) {
        Pointer tableRef = p.getPointer(0L);
        Pointer functionRef = tableRef.getPointer((long)(offset * Native.POINTER_SIZE));
        return Function.getFunction((Pointer)functionRef, (int)63);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(" [").append(this.implementing).append("] ").append(this.guid);
        for (ComFunction cf : this.functions.values()) {
            sb.append('\n').append(cf);
        }
        return sb.toString();
    }
}

