/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot.win;

import com.intuit.karate.robot.win.ComFunction;
import com.intuit.karate.robot.win.ComInterface;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.ITypeInfo;
import com.sun.jna.platform.win32.COM.TypeInfo;
import com.sun.jna.platform.win32.COM.TypeLib;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComLibrary {
    private static final Logger logger = LoggerFactory.getLogger(ComLibrary.class);
    public final String name;
    public final String clsId;
    public final int majorVersion;
    public final int minorVersion;
    public final Map<String, Map<String, Integer>> enumKeyValues = new HashMap<String, Map<String, Integer>>();
    public final Map<String, Map<Integer, String>> enumValueKeys = new HashMap<String, Map<Integer, String>>();
    public final Map<String, ComInterface> interfaces = new HashMap<String, ComInterface>();

    public ComLibrary(String typeLibClsId, int majorVersion, int minorVersion) {
        WinDef.LCID lcId = Kernel32.INSTANCE.GetUserDefaultLCID();
        Guid.CLSID.ByReference clsIdRef = new Guid.CLSID.ByReference();
        WinNT.HRESULT hr = Ole32.INSTANCE.CLSIDFromString(typeLibClsId, clsIdRef);
        COMUtils.checkRC((WinNT.HRESULT)hr);
        PointerByReference typeLibRef = new PointerByReference();
        hr = OleAuto.INSTANCE.LoadRegTypeLib((Guid.GUID)clsIdRef, majorVersion, minorVersion, lcId, typeLibRef);
        COMUtils.checkRC((WinNT.HRESULT)hr);
        TypeLib typeLib = new TypeLib(typeLibRef.getValue());
        this.name = ComLibrary.getName(typeLib, -1);
        this.clsId = clsIdRef.toGuidString();
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        logger.debug("loaded: {}, clsid: {}, majorVersion: {}, minorVersion: {}", new Object[]{this.name, this.clsId, majorVersion, minorVersion});
        int typeCount = typeLib.GetTypeInfoCount().intValue();
        if (logger.isTraceEnabled()) {
            logger.trace("name: {}, types: {}", (Object)this.name, (Object)typeCount);
        }
        block4: for (int i = 0; i < typeCount; ++i) {
            String typeName = ComLibrary.getName(typeLib, i);
            ITypeInfo typeInfo = ComLibrary.getTypeInfo(typeLib, i);
            OaIdl.TYPEATTR typeAttr = ComLibrary.getTypeAttr(typeInfo);
            String guid = typeAttr.guid.toGuidString();
            OaIdl.TYPEKIND typeKind = ComLibrary.getTypeKind(typeLib, i);
            switch (typeKind.value) {
                case 0: 
                case 2: {
                    this.getEnums(typeName, typeInfo, typeAttr);
                    continue block4;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.getInterfaces(guid, typeName, typeInfo, typeAttr);
                    continue block4;
                }
                default: {
                    if (!logger.isTraceEnabled()) continue block4;
                    logger.trace("==== ignore: {}", (Object)typeName);
                }
            }
        }
    }

    private void getInterfaces(String guid, String interfaceName, ITypeInfo typeInfo, OaIdl.TYPEATTR typeAttr) {
        int implCount = typeAttr.cImplTypes.intValue();
        if (implCount > 0) {
            for (int i = 0; i < implCount; ++i) {
                OaIdl.HREFTYPE refTypeOfImplType = ComLibrary.getRefType(typeInfo, i);
                ITypeInfo refTypeInfo = ComLibrary.getRefTypeInfo(typeInfo, refTypeOfImplType);
                String implementingName = ComLibrary.getName(refTypeInfo, new OaIdl.MEMBERID(-1));
                ComInterface ci = new ComInterface(interfaceName, implementingName, guid);
                this.interfaces.put(interfaceName, ci);
                this.getFunctions(ci, typeInfo);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("==== interface: {}", (Object)ci);
            }
        }
    }

    private void getFunctions(ComInterface ci, ITypeInfo typeInfo) {
        OaIdl.TYPEATTR typeAttr = ComLibrary.getTypeAttr(typeInfo);
        int count = typeAttr.cFuncs.intValue();
        for (int i = 0; i < count; ++i) {
            OaIdl.FUNCDESC funcDesc = ComLibrary.getFuncDesc(typeInfo, i);
            short paramCount = funcDesc.cParams.shortValue();
            int vtableId = funcDesc.oVft.intValue();
            int memberId = funcDesc.memid.intValue();
            String[] names = ComLibrary.getNames(typeInfo, funcDesc.memid, paramCount + 1);
            String functionName = names[0];
            ComFunction cf = new ComFunction(functionName, vtableId, memberId);
            ci.add(cf);
            this.getArgs(cf, names, typeInfo, funcDesc);
        }
    }

    private void getArgs(ComFunction cf, String[] names, ITypeInfo typeInfo, OaIdl.FUNCDESC funcDesc) {
        for (int i = 1; i < names.length; ++i) {
            OaIdl.ELEMDESC elemdesc = funcDesc.lprgelemdescParam.elemDescArg[i - 1];
            cf.addArg(names[i]);
        }
    }

    private static String[] getNames(ITypeInfo typeInfo, OaIdl.MEMBERID memberId, int maxNames) {
        WTypes.BSTR[] namesRef = new WTypes.BSTR[maxNames];
        WinDef.UINTByReference indexRef = new WinDef.UINTByReference();
        WinNT.HRESULT hr = typeInfo.GetNames(memberId, namesRef, new WinDef.UINT((long)maxNames), indexRef);
        COMUtils.checkRC((WinNT.HRESULT)hr);
        int cNames = indexRef.getValue().intValue();
        String[] result = new String[cNames];
        for (int i = 0; i < result.length; ++i) {
            result[i] = namesRef[i].getValue();
            OleAuto.INSTANCE.SysFreeString(namesRef[i]);
        }
        return result;
    }

    private static OaIdl.FUNCDESC getFuncDesc(ITypeInfo typeInfo, int index) {
        PointerByReference funcDescRef = new PointerByReference();
        WinNT.HRESULT hr = typeInfo.GetFuncDesc(new WinDef.UINT((long)index), funcDescRef);
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return new OaIdl.FUNCDESC(funcDescRef.getValue());
    }

    private static OaIdl.HREFTYPE getRefType(ITypeInfo typeInfo, int index) {
        OaIdl.HREFTYPEByReference refTypeRef = new OaIdl.HREFTYPEByReference();
        WinNT.HRESULT hr = typeInfo.GetRefTypeOfImplType(new WinDef.UINT((long)index), refTypeRef);
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return refTypeRef.getValue();
    }

    private static ITypeInfo getRefTypeInfo(ITypeInfo typeInfo, OaIdl.HREFTYPE hrefType) {
        PointerByReference refTypeInfoRef = new PointerByReference();
        WinNT.HRESULT hr = typeInfo.GetRefTypeInfo(hrefType, refTypeInfoRef);
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return new TypeInfo(refTypeInfoRef.getValue());
    }

    private void getEnums(String enumName, ITypeInfo typeInfo, OaIdl.TYPEATTR typeAttr) {
        int varCount = typeAttr.cVars.intValue();
        LinkedHashMap<String, Integer> keyValues = new LinkedHashMap<String, Integer>();
        this.enumKeyValues.put(enumName, keyValues);
        HashMap<Integer, String> valueKeys = new HashMap<Integer, String>();
        this.enumValueKeys.put(enumName, valueKeys);
        if (varCount > 0) {
            for (int i = 0; i < varCount; ++i) {
                OaIdl.VARDESC varDesc = ComLibrary.getVarDesc(typeInfo, i);
                Variant.VARIANT.ByReference constValue = varDesc._vardesc.lpvarValue;
                Object value = constValue.getValue();
                OaIdl.MEMBERID memberId = varDesc.memid;
                String name = ComLibrary.getName(typeInfo, memberId);
                Integer intValue = Integer.valueOf(value.toString());
                keyValues.put(name, intValue);
                valueKeys.put(intValue, name);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("enum: {} - {}", (Object)enumName, keyValues);
        }
    }

    private static OaIdl.VARDESC getVarDesc(ITypeInfo typeInfo, int index) {
        PointerByReference varDescRef = new PointerByReference();
        WinNT.HRESULT hr = typeInfo.GetVarDesc(new WinDef.UINT((long)index), varDescRef);
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return new OaIdl.VARDESC(varDescRef.getValue());
    }

    private static String getName(TypeLib typeLib, int index) {
        WTypes.BSTRByReference nameRef = new WTypes.BSTRByReference();
        WTypes.BSTRByReference docRef = new WTypes.BSTRByReference();
        WinDef.DWORDByReference helpRef = new WinDef.DWORDByReference();
        WTypes.BSTRByReference helpFileRef = new WTypes.BSTRByReference();
        WinNT.HRESULT hr = typeLib.GetDocumentation(index, nameRef, docRef, helpRef, helpFileRef);
        COMUtils.checkRC((WinNT.HRESULT)hr);
        String name = nameRef.getString();
        OleAuto.INSTANCE.SysFreeString(nameRef.getValue());
        OleAuto.INSTANCE.SysFreeString(docRef.getValue());
        OleAuto.INSTANCE.SysFreeString(helpFileRef.getValue());
        return name;
    }

    private static String getName(ITypeInfo typeInfo, OaIdl.MEMBERID memberId) {
        WTypes.BSTRByReference nameRef = new WTypes.BSTRByReference();
        WTypes.BSTRByReference docRef = new WTypes.BSTRByReference();
        WinDef.DWORDByReference helpRef = new WinDef.DWORDByReference();
        WTypes.BSTRByReference helpFileRef = new WTypes.BSTRByReference();
        WinNT.HRESULT hr = typeInfo.GetDocumentation(memberId, nameRef, docRef, helpRef, helpFileRef);
        COMUtils.checkRC((WinNT.HRESULT)hr);
        String name = nameRef.getString();
        OleAuto.INSTANCE.SysFreeString(nameRef.getValue());
        OleAuto.INSTANCE.SysFreeString(docRef.getValue());
        OleAuto.INSTANCE.SysFreeString(helpFileRef.getValue());
        return name;
    }

    private static OaIdl.TYPEKIND getTypeKind(TypeLib typeLib, int index) {
        OaIdl.TYPEKIND.ByReference typeKind = new OaIdl.TYPEKIND.ByReference();
        WinNT.HRESULT hr = typeLib.GetTypeInfoType(new WinDef.UINT((long)index), typeKind);
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return typeKind;
    }

    private static ITypeInfo getTypeInfo(TypeLib typeLib, int index) {
        PointerByReference typeInfoRef = new PointerByReference();
        WinNT.HRESULT hr = typeLib.GetTypeInfo(new WinDef.UINT((long)index), typeInfoRef);
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return new TypeInfo(typeInfoRef.getValue());
    }

    private static OaIdl.TYPEATTR getTypeAttr(ITypeInfo typeInfo) {
        PointerByReference typeAttrRef = new PointerByReference();
        WinNT.HRESULT hr = typeInfo.GetTypeAttr(typeAttrRef);
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return new OaIdl.TYPEATTR(typeAttrRef.getValue());
    }
}

