/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot.win;

import java.util.HashMap;
import java.util.Map;

public enum ControlType {
    Button(50000),
    Calendar(50001),
    CheckBox(50002),
    ComboBox(50003),
    Edit(50004),
    Hyperlink(50005),
    Image(50006),
    ListItem(50007),
    List(50008),
    Menu(50009),
    MenuBar(50010),
    MenuItem(50011),
    ProgressBar(50012),
    RadioButton(50013),
    ScrollBar(50014),
    Slider(50015),
    Spinner(50016),
    StatusBar(50017),
    Tab(50018),
    TabItem(50019),
    Text(50020),
    ToolBar(50021),
    ToolTip(50022),
    Tree(50023),
    TreeItem(50024),
    Custom(50025),
    Group(50026),
    Thumb(50027),
    DataGrid(50028),
    DataItem(50029),
    Document(50030),
    SplitButton(50031),
    Window(50032),
    Pane(50033),
    Header(50034),
    HeaderItem(50035),
    Table(50036),
    TitleBar(50037),
    Separator(50038),
    SemanticZoom(50039),
    AppBar(50040);

    public final int value;
    private static final Map<Integer, ControlType> FROM_VALUE;
    private static final Map<String, ControlType> FROM_NAME;

    private ControlType(int value) {
        this.value = value;
    }

    public static ControlType fromValue(int value) {
        return FROM_VALUE.get(value);
    }

    public static ControlType fromName(String name) {
        return FROM_NAME.get(name.toLowerCase());
    }

    static {
        ControlType[] values = ControlType.values();
        FROM_VALUE = new HashMap<Integer, ControlType>(values.length);
        FROM_NAME = new HashMap<String, ControlType>(values.length);
        for (ControlType ct : values) {
            FROM_VALUE.put(ct.value, ct);
            FROM_NAME.put(ct.name().toLowerCase(), ct);
        }
    }
}

