/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot.win;

import com.intuit.karate.robot.win.ComAllocated;
import com.intuit.karate.robot.win.ComInterface;
import com.intuit.karate.robot.win.ComRef;
import com.intuit.karate.robot.win.ComUtils;
import com.intuit.karate.robot.win.IUIAutomationCondition;
import com.intuit.karate.robot.win.IUIAutomationElement;
import com.sun.jna.Function;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;

public abstract class IUIAutomationBase
extends ComRef {
    protected final ComInterface INTERFACE;

    public IUIAutomationBase() {
        this(new PointerByReference());
    }

    public IUIAutomationBase(PointerByReference ref) {
        super(ref);
        String interfaceName = this.getClass().getSimpleName();
        this.INTERFACE = ComUtils.LIBRARY.interfaces.get(interfaceName);
        if (this.INTERFACE == null) {
            throw new RuntimeException("could not resolve interface: " + interfaceName);
        }
    }

    protected static int enumValue(String name, String key) {
        return ComUtils.enumValue(name, key);
    }

    protected static String enumKey(String name, int value) {
        return ComUtils.enumKey(name, value);
    }

    public int invoke(int offset, Object ... args) {
        Function function = this.INTERFACE.getFunction(offset, this.REF.getValue());
        return this.invoke("offset: " + offset, function, args);
    }

    public int invoke(String name, Object ... args) {
        Function function = this.INTERFACE.getFunction(name, this.REF.getValue());
        return this.invoke(name, function, args);
    }

    public int invoke(String name, Function function, Object ... args) {
        int res = -1;
        ArrayList<ComAllocated> toFree = new ArrayList<ComAllocated>(args.length);
        ComRef lastArg = null;
        try {
            Object[] refs = new Object[args.length + 1];
            refs[0] = this.REF.getValue();
            for (int i = 0; i < args.length; ++i) {
                Object val;
                Object arg = args[i];
                if (arg instanceof ComRef) {
                    ComRef ref = (ComRef)arg;
                    if (i == args.length - 1) {
                        val = ref.REF;
                        lastArg = ref;
                    } else {
                        val = ref.REF.getValue();
                    }
                } else if (arg instanceof ComAllocated) {
                    ComAllocated ca = (ComAllocated)arg;
                    toFree.add(ca);
                    val = ca.value();
                } else {
                    val = arg;
                }
                refs[i + 1] = val;
            }
            res = function.invokeInt(refs);
            if (res != 0) {
                logger.warn("{}.{} returned non-zero: {}", new Object[]{this.INTERFACE.name, name, res});
                if (lastArg != null) {
                    lastArg.setValid(false);
                }
            }
            if (lastArg != null && lastArg.isNull() && logger.isTraceEnabled()) {
                logger.trace("{}.{} returned null: {}", new Object[]{this.INTERFACE.name, name, lastArg.REF});
            }
        }
        catch (Exception e) {
            String message = this.INTERFACE.name + "." + name + " failed with exception: " + e.getMessage();
            logger.error(message);
            throw new RuntimeException(e);
        }
        finally {
            toFree.forEach(ComAllocated::free);
        }
        return res;
    }

    public <T> T invoke(Class<T> clazz, String name, Object ... args) {
        T ref;
        try {
            ref = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Object[] refs = new Object[args.length + 1];
        System.arraycopy(args, 0, refs, 0, args.length);
        refs[args.length] = ref;
        this.invoke(name, refs);
        return ref;
    }

    public IUIAutomationElement invokeForElement(String name, Object ... args) {
        return this.invoke(IUIAutomationElement.class, name, args);
    }

    public IUIAutomationCondition invokeForCondition(String name, Object ... args) {
        return this.invoke(IUIAutomationCondition.class, name, args);
    }

    public String invokeForString(String name) {
        ComRef ref = new ComRef();
        this.invoke(name, ref);
        return ref.isNull() ? "" : ref.asString();
    }

    public int invokeForInt(String name) {
        IntByReference ref = new IntByReference();
        this.invoke(name, ref);
        return ref.getValue();
    }

    public boolean invokeForBool(String name) {
        return this.invokeForInt(name) != 0;
    }

    public double invokeForDouble(String name) {
        DoubleByReference ref = new DoubleByReference();
        this.invoke(name, ref);
        return ref.getValue();
    }
}

