/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot.win;

import com.intuit.karate.robot.win.ControlType;
import com.intuit.karate.robot.win.IUIAutomationBase;
import com.intuit.karate.robot.win.IUIAutomationCondition;
import com.intuit.karate.robot.win.IUIAutomationElementArray;
import com.intuit.karate.robot.win.Pattern;
import com.intuit.karate.robot.win.Property;
import com.intuit.karate.robot.win.TreeScope;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.PointerByReference;

public class IUIAutomationElement
extends IUIAutomationBase {
    public String getCurrentName() {
        return this.invokeForString("CurrentName");
    }

    public ControlType getControlType() {
        int controlType = this.getCurrentPropertyValue(Property.ControlType).intValue();
        return ControlType.fromValue(controlType);
    }

    public String getClassName() {
        return this.getCurrentPropertyValue(Property.ClassName).stringValue();
    }

    public String getAutomationId() {
        return this.getCurrentPropertyValue(Property.AutomationId).stringValue();
    }

    public IUIAutomationElement findFirst(TreeScope scope, IUIAutomationCondition condition) {
        return this.invokeForElement("FindFirst", scope.value, condition);
    }

    public IUIAutomationElementArray findAll(TreeScope scope, IUIAutomationCondition condition) {
        return this.invoke(IUIAutomationElementArray.class, "FindAll", scope.value, condition);
    }

    public Variant.VARIANT getCurrentPropertyValue(Property property) {
        return this.invoke(Variant.VARIANT.class, "GetCurrentPropertyValue", property.value);
    }

    public void setFocus() {
        this.invoke("SetFocus", new Object[0]);
    }

    public WinDef.POINT getClickablePoint() {
        WinDef.POINT.ByReference point = new WinDef.POINT.ByReference();
        WinDef.BOOLByReference status = new WinDef.BOOLByReference();
        this.invoke("GetClickablePoint", point, status);
        if (!status.getValue().booleanValue()) {
            logger.warn("failed to get clickable point");
            return null;
        }
        return point;
    }

    public WinDef.RECT getCurrentBoundingRectangle() {
        return this.invoke(WinDef.RECT.class, "CurrentBoundingRectangle", new Object[0]);
    }

    public <T> T getCurrentPattern(Class<T> type) {
        Pattern pattern = Pattern.fromType(type);
        if (pattern == null) {
            throw new RuntimeException("unsupported pattern: " + type);
        }
        return this.invoke(type, "GetCurrentPattern", pattern.value);
    }

    public WinDef.HWND getCurrentNativeWindowHandle() {
        PointerByReference pbr = new PointerByReference();
        this.invoke("CurrentNativeWindowHandle", pbr);
        return new WinDef.HWND(pbr.getValue());
    }

    public boolean getCurrentIsEnabled() {
        return this.invokeForBool("CurrentIsEnabled");
    }

    public String toString() {
        if (!this.isValid()) {
            return "(stale)";
        }
        try {
            return this.getControlType() + ":" + this.getCurrentName();
        }
        catch (Exception e) {
            return "(stale) " + e.getMessage();
        }
    }
}

