/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot.win;

import com.intuit.karate.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathSearch {
    private static final Pattern PATH_CHUNK = Pattern.compile("([^.{]+)?(\\.[^{]+)?(\\{.+\\})?");
    private static final char SLASH = '/';
    public final boolean findAll;
    private final String path;
    public final List<Chunk> chunks;

    public static boolean isWildcard(String locator) {
        char firstChar = locator.charAt(0);
        return firstChar == '^' || firstChar == '~';
    }

    public PathSearch(String path, boolean findAll) {
        this.path = path;
        this.findAll = findAll;
        this.chunks = PathSearch.split(path);
    }

    public static List<Chunk> split(String s) {
        String temp;
        int pos = ((String)s).indexOf(47);
        if (pos == -1) {
            throw new RuntimeException("path did not start with or contain '/'");
        }
        ArrayList<Chunk> list = new ArrayList<Chunk>();
        int startPos = 0;
        int searchPos = 0;
        boolean anyDepth = false;
        while (pos != -1) {
            if (pos == 0) {
                startPos = 1;
                searchPos = 1;
            } else if (((String)s).charAt(pos - 1) == '\\') {
                s = ((String)s).substring(0, pos - 1) + ((String)s).substring(pos);
                searchPos = pos;
            } else {
                temp = ((String)s).substring(startPos, pos);
                if (temp.isEmpty()) {
                    anyDepth = true;
                } else {
                    list.add(new Chunk(anyDepth, temp));
                    anyDepth = false;
                }
                searchPos = startPos = pos + 1;
            }
            pos = ((String)s).indexOf(47, searchPos);
        }
        if (startPos != ((String)s).length() && !(temp = ((String)s).substring(startPos)).isEmpty()) {
            list.add(new Chunk(anyDepth, temp));
        }
        return list;
    }

    public String toString() {
        return this.path;
    }

    protected static class Chunk {
        final String raw;
        final boolean anyDepth;
        final String controlType;
        final String className;
        final int index;
        final Predicate<String> nameCondition;
        final String name;

        Chunk(boolean anyDepth, String raw) {
            this.anyDepth = anyDepth;
            this.raw = raw;
            Matcher matcher = PATH_CHUNK.matcher(raw);
            if (!matcher.find()) {
                throw new RuntimeException("invalid path pattern: " + raw);
            }
            String typeAndIndex = matcher.group(1);
            if (typeAndIndex == null) {
                this.index = -1;
                this.controlType = null;
            } else {
                int pos = typeAndIndex.indexOf(91);
                if (pos != -1) {
                    int endPos = raw.indexOf(93, pos);
                    String temp = raw.substring(pos + 1, endPos);
                    this.index = Integer.valueOf(temp) - 1;
                    this.controlType = typeAndIndex.substring(0, pos);
                } else {
                    this.index = -1;
                    this.controlType = typeAndIndex;
                }
            }
            String dotAndClassName = matcher.group(2);
            this.className = dotAndClassName == null ? null : dotAndClassName.substring(1);
            String prefixAndName = matcher.group(3);
            if (prefixAndName == null) {
                this.name = null;
                this.nameCondition = null;
            } else {
                prefixAndName = prefixAndName.substring(1, prefixAndName.length() - 1);
                switch (prefixAndName.charAt(0)) {
                    case '^': {
                        this.name = prefixAndName.substring(1);
                        this.nameCondition = s -> s.contains(this.name);
                        break;
                    }
                    case '~': {
                        this.name = prefixAndName.substring(1);
                        Pattern pattern = Pattern.compile(this.name);
                        this.nameCondition = s -> pattern.matcher((CharSequence)s).find();
                        break;
                    }
                    default: {
                        this.name = StringUtils.trimToNull((String)prefixAndName);
                        this.nameCondition = this.name == null ? null : s -> s.equals(this.name);
                    }
                }
            }
        }

        public String toString() {
            return (this.anyDepth ? "//" : "/") + this.raw;
        }
    }
}

