/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot.win;

import com.intuit.karate.robot.win.IUIAutomationInvokePattern;
import com.intuit.karate.robot.win.IUIAutomationScrollPattern;
import com.intuit.karate.robot.win.IUIAutomationSelectionItemPattern;
import com.intuit.karate.robot.win.IUIAutomationValuePattern;
import com.intuit.karate.robot.win.IUIAutomationWindowPattern;
import java.util.HashMap;
import java.util.Map;

public enum Pattern {
    Invoke(10000, IUIAutomationInvokePattern.class),
    Selection(10001),
    Value(10002, IUIAutomationValuePattern.class),
    RangeValue(10003),
    Scroll(10004, IUIAutomationScrollPattern.class),
    ExpandCollapse(10005),
    Grid(10006),
    GridItem(10007),
    MultipleView(10008),
    Window(10009, IUIAutomationWindowPattern.class),
    SelectionItem(10010, IUIAutomationSelectionItemPattern.class),
    Dock(10011),
    Table(10012),
    TableItem(10013),
    Text(10014),
    Toggle(10015),
    Transform(10016),
    ScrollItem(10017),
    LegacyIAccessible(10018),
    ItemContainer(10019),
    VirtualizedItem(10020),
    SynchronizedInput(10021),
    ObjectModel(10022),
    Annotation(10023),
    Text2(10024),
    Styles(10025),
    Spreadsheet(10026),
    SpreadsheetItem(10027),
    Transform2(10028),
    TextChild(10029),
    Drag(10030),
    DropTarget(10031),
    TextEdit(10032),
    CustomNavigation(10033);

    public final int value;
    public final Class type;
    private static final Map<String, Pattern> FROM_CLASS;
    private static final Map<String, Pattern> FROM_NAME;

    private Pattern(int value) {
        this(value, null);
    }

    private Pattern(int value, Class type) {
        this.value = value;
        this.type = type;
    }

    public static Pattern fromType(Class type) {
        return FROM_CLASS.get(type.getSimpleName());
    }

    public static Pattern fromName(String name) {
        return FROM_NAME.get(name.toLowerCase());
    }

    static {
        Pattern[] values = Pattern.values();
        FROM_CLASS = new HashMap<String, Pattern>(values.length);
        FROM_NAME = new HashMap<String, Pattern>(values.length);
        for (Pattern p : values) {
            if (p.type != null) {
                FROM_CLASS.put(p.type.getSimpleName(), p);
            }
            FROM_NAME.put(p.name().toLowerCase(), p);
        }
    }
}

