/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot.win;

import com.intuit.karate.Logger;
import com.intuit.karate.robot.Element;
import com.intuit.karate.robot.Location;
import com.intuit.karate.robot.Region;
import com.intuit.karate.robot.RobotBase;
import com.intuit.karate.robot.win.IUIAutomationElement;
import com.intuit.karate.robot.win.IUIAutomationElementArray;
import com.intuit.karate.robot.win.IUIAutomationInvokePattern;
import com.intuit.karate.robot.win.IUIAutomationScrollPattern;
import com.intuit.karate.robot.win.IUIAutomationSelectionItemPattern;
import com.intuit.karate.robot.win.IUIAutomationTreeWalker;
import com.intuit.karate.robot.win.IUIAutomationValuePattern;
import com.intuit.karate.robot.win.Pattern;
import com.intuit.karate.robot.win.Property;
import com.intuit.karate.robot.win.ScrollAmount;
import com.intuit.karate.robot.win.TreeScope;
import com.intuit.karate.robot.win.WinRobot;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinDef;
import java.util.ArrayList;
import java.util.List;

public class WinElement
implements Element {
    protected final IUIAutomationElement e;
    private final WinRobot robot;
    private final Logger logger;

    public WinElement(WinRobot robot, IUIAutomationElement e) {
        this.robot = robot;
        this.e = e;
        this.logger = robot.getLogger();
    }

    @Override
    public RobotBase getRobot() {
        return this.robot;
    }

    @Override
    public boolean isPresent() {
        return this.e.isValid() && !this.e.isNull();
    }

    @Override
    public boolean isEnabled() {
        return this.e.getCurrentIsEnabled();
    }

    @Override
    public boolean isImage() {
        return false;
    }

    @Override
    public Region getRegion() {
        WinDef.RECT rect = this.e.getCurrentBoundingRectangle();
        return new Region(this.robot, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    private Location getClickablePoint() {
        WinDef.POINT p = this.e.getClickablePoint();
        return p == null ? this.getRegion().getCenter() : new Location(this.robot, p.x, p.y);
    }

    @Override
    public Element focus() {
        this.e.setFocus();
        return this;
    }

    public Element invoke() {
        if (this.isInvokePatternAvailable()) {
            IUIAutomationInvokePattern invokePattern = this.e.getCurrentPattern(IUIAutomationInvokePattern.class);
            invokePattern.invoke();
        } else {
            this.click();
        }
        return this;
    }

    @Override
    public Element click() {
        this.getClickablePoint().click();
        return this;
    }

    @Override
    public Element move() {
        this.getClickablePoint().move();
        return this;
    }

    @Override
    public Element press() {
        this.getClickablePoint().press();
        return this;
    }

    @Override
    public Element release() {
        this.getClickablePoint().release();
        return this;
    }

    @Override
    public String getName() {
        return this.e.getCurrentName();
    }

    private boolean isValuePatternAvailable() {
        Variant.VARIANT variant = this.e.getCurrentPropertyValue(Property.IsValuePatternAvailable);
        return variant.booleanValue();
    }

    private boolean isInvokePatternAvailable() {
        Variant.VARIANT variant = this.e.getCurrentPropertyValue(Property.IsInvokePatternAvailable);
        return variant.booleanValue();
    }

    private boolean isScrollPatternAvailable() {
        Variant.VARIANT variant = this.e.getCurrentPropertyValue(Property.IsScrollPatternAvailable);
        return variant.booleanValue();
    }

    @Override
    public String getValue() {
        if (this.isValuePatternAvailable()) {
            return this.e.getCurrentPattern(IUIAutomationValuePattern.class).getCurrentValue();
        }
        return null;
    }

    @Override
    public Element clear() {
        if (this.isValuePatternAvailable()) {
            IUIAutomationValuePattern valuePattern = this.e.getCurrentPattern(IUIAutomationValuePattern.class);
            valuePattern.setCurrentValue("");
        } else {
            this.e.setFocus();
            this.robot.clearFocused();
        }
        return this;
    }

    @Override
    public Element input(String value) {
        if (this.isValuePatternAvailable()) {
            IUIAutomationValuePattern valuePattern = this.e.getCurrentPattern(IUIAutomationValuePattern.class);
            valuePattern.setCurrentValue(value);
        } else {
            this.e.setFocus();
            this.robot.input(value);
        }
        return this;
    }

    @Override
    public Element delay(int millis) {
        this.robot.delay(millis);
        return this;
    }

    @Override
    public List<Element> getChildren() {
        IUIAutomationElementArray array = this.e.findAll(TreeScope.Children, WinRobot.UIA.createTrueCondition());
        int count = array.getLength();
        ArrayList<Element> list = new ArrayList<Element>(count);
        for (int i = 0; i < count; ++i) {
            IUIAutomationElement child = array.getElement(i);
            list.add(new WinElement(this.robot, child));
        }
        return list;
    }

    private IUIAutomationTreeWalker walk() {
        return WinRobot.UIA.getControlViewWalker();
    }

    @Override
    public Element getParent() {
        return new WinElement(this.robot, this.walk().getParentElement(this.e));
    }

    public Element getFirstChild() {
        return new WinElement(this.robot, this.walk().getFirstChildElement(this.e));
    }

    public Element getLastChild() {
        return new WinElement(this.robot, this.walk().getLastChildElement(this.e));
    }

    public Element getNextSibling() {
        return new WinElement(this.robot, this.walk().getNextSiblingElement(this.e));
    }

    public Element getPreviousSibling() {
        return new WinElement(this.robot, this.walk().getPreviousSiblingElement(this.e));
    }

    public IUIAutomationElement toNative() {
        return this.e;
    }

    public Object property(String propertyName) {
        Property property = Property.valueOf(propertyName);
        Variant.VARIANT variant = this.e.getCurrentPropertyValue(property);
        return variant.getValue();
    }

    public Object property(int propertyId) {
        Property property = Property.fromId(propertyId);
        Variant.VARIANT variant = this.e.getCurrentPropertyValue(property);
        return variant.getValue();
    }

    @Override
    public String getDebugString() {
        if (!this.e.isValid()) {
            return "(null)";
        }
        try {
            return "'" + this.e.getCurrentName() + "' " + this.e.getControlType();
        }
        catch (Exception e) {
            return "(stale) " + e.getMessage();
        }
    }

    public String toString() {
        return this.getDebugString();
    }

    @Override
    public Element select() {
        IUIAutomationSelectionItemPattern pattern = this.e.getCurrentPattern(IUIAutomationSelectionItemPattern.class);
        pattern.select();
        return this;
    }

    public Element scrollDown() {
        return this.scrollDown(false);
    }

    public Element scrollUp() {
        return this.scrollUp(false);
    }

    public Element scrollDown(boolean large) {
        if (this.isScrollPatternAvailable()) {
            IUIAutomationScrollPattern pattern = this.e.getCurrentPattern(IUIAutomationScrollPattern.class);
            ScrollAmount sa = large ? ScrollAmount.LargeIncrement : ScrollAmount.SmallIncrement;
            pattern.scroll(sa);
        } else {
            this.logger.warn("scroll pattern not available on: {}", new Object[]{this.getName()});
        }
        return this;
    }

    public Element scrollUp(boolean large) {
        if (this.isScrollPatternAvailable()) {
            IUIAutomationScrollPattern pattern = this.e.getCurrentPattern(IUIAutomationScrollPattern.class);
            ScrollAmount sa = large ? ScrollAmount.LargeDecrement : ScrollAmount.SmallDecrement;
            pattern.scroll(sa);
        } else {
            this.logger.warn("scroll pattern not available on: {}", new Object[]{this.getName()});
        }
        return this;
    }

    public Element scroll(double horizontalPercent, double verticalPercent) {
        if (this.isScrollPatternAvailable()) {
            IUIAutomationScrollPattern pattern = this.e.getCurrentPattern(IUIAutomationScrollPattern.class);
            pattern.setScrollPercent(horizontalPercent, verticalPercent);
        } else {
            this.logger.warn("scroll pattern not available on: {}", new Object[]{this.getName()});
        }
        return this;
    }

    public Object as(String patternName) {
        Pattern pattern = Pattern.fromName(patternName);
        if (pattern == null) {
            throw new RuntimeException("no such pattern: " + patternName);
        }
        if (pattern.type == null) {
            throw new RuntimeException("pattern not implemented: " + pattern);
        }
        return this.e.getCurrentPattern(pattern.type);
    }
}

