/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.robot.win;

import com.intuit.karate.core.AutoDef;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.http.HttpClientFactory;
import com.intuit.karate.robot.Element;
import com.intuit.karate.robot.Location;
import com.intuit.karate.robot.Robot;
import com.intuit.karate.robot.RobotBase;
import com.intuit.karate.robot.StringMatcher;
import com.intuit.karate.robot.Window;
import com.intuit.karate.robot.win.ControlType;
import com.intuit.karate.robot.win.IUIAutomation;
import com.intuit.karate.robot.win.IUIAutomationCondition;
import com.intuit.karate.robot.win.IUIAutomationElement;
import com.intuit.karate.robot.win.IUIAutomationElementArray;
import com.intuit.karate.robot.win.IUIAutomationTreeWalker;
import com.intuit.karate.robot.win.PathSearch;
import com.intuit.karate.robot.win.Property;
import com.intuit.karate.robot.win.TreeScope;
import com.intuit.karate.robot.win.WinElement;
import com.intuit.karate.robot.win.WinWindow;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class WinRobot
extends RobotBase {
    protected static final IUIAutomation UIA = IUIAutomation.INSTANCE;

    public WinRobot(ScenarioRuntime runtime, Map<String, Object> options) {
        super(runtime, options);
    }

    public static WinRobot start(Map<String, Object> options) {
        ScenarioRuntime runtime = (ScenarioRuntime)FeatureRuntime.forTempUse((HttpClientFactory)HttpClientFactory.DEFAULT).scenarios.next();
        ScenarioEngine.set((ScenarioEngine)runtime.engine);
        return new WinRobot(runtime, options);
    }

    public Map<String, Object> afterScenario() {
        this.logger.debug("after scenario, current window: {}", new Object[]{this.currentWindow});
        if (this.autoClose && this.command != null && this.currentWindow != null) {
            this.logger.debug("will attempt to close window for: {}", new Object[]{this.currentWindow.getName()});
            WinDef.HWND hwnd = ((IUIAutomationElement)this.currentWindow.toNative()).getCurrentNativeWindowHandle();
            User32.INSTANCE.PostMessage(hwnd, 18, null, null);
            this.command.close(false);
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public List<Window> getAllWindows() {
        IUIAutomationCondition isWindow = UIA.createPropertyCondition(Property.ControlType, ControlType.Window.value);
        IUIAutomationElementArray array = UIA.getRootElement().findAll(TreeScope.Descendants, isWindow);
        int count = array.getLength();
        ArrayList<Window> list = new ArrayList<Window>(count);
        for (int i = 0; i < count; ++i) {
            IUIAutomationElement e = array.getElement(i);
            if (!e.isValid()) continue;
            list.add(new WinWindow(this, e));
        }
        return list;
    }

    @Override
    protected Element windowInternal(String title) {
        return this.windowInternal(new StringMatcher(title));
    }

    @Override
    protected Element windowInternal(Predicate<String> condition) {
        IUIAutomationCondition isWindow = UIA.createPropertyCondition(Property.ControlType, ControlType.Window.value);
        IUIAutomationElementArray windows = UIA.getRootElement().findAll(TreeScope.Descendants, isWindow);
        int count = windows.getLength();
        for (int i = 0; i < count; ++i) {
            IUIAutomationElement child = windows.getElement(i);
            if (!child.isValid()) {
                this.logger.warn("invalid window: {}", new Object[]{child});
                continue;
            }
            String name = child.getCurrentName();
            if (name == null) {
                this.logger.warn("name is null for window: {}", new Object[]{child});
                continue;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("scanning window: {}", new Object[]{name});
            }
            if (!condition.test(name)) continue;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("found window: {}", new Object[]{name});
            }
            return new WinWindow(this, child).focus();
        }
        this.logger.warn("failed to find window: {}", new Object[]{condition});
        return null;
    }

    private IUIAutomationCondition by(Property property, String value) {
        return UIA.createPropertyCondition(property, value);
    }

    protected List<Element> toElements(IUIAutomationElementArray array) {
        int count = array.getLength();
        ArrayList<Element> list = new ArrayList<Element>(count);
        for (int i = 0; i < count; ++i) {
            IUIAutomationElement e = array.getElement(i);
            if (!e.isValid()) continue;
            list.add(new WinElement(this, e));
        }
        return list;
    }

    @Override
    public List<Element> locateAllInternal(Element root, String locator) {
        IUIAutomationElement parent = (IUIAutomationElement)root.toNative();
        if (PathSearch.isWildcard((String)locator)) {
            locator = "//*{" + (String)locator + "}";
        }
        if (((String)locator).startsWith("/")) {
            if (((String)locator).startsWith("/root")) {
                locator = ((String)locator).substring(5);
                parent = UIA.getRootElement();
            }
            ArrayList<Element> searchResults = new ArrayList<Element>();
            PathSearch search = new PathSearch((String)locator, true);
            this.walkPathAndFind(searchResults, search, UIA.getControlViewWalker(), parent, 0);
            return searchResults;
        }
        IUIAutomationCondition condition = ((String)locator).startsWith("#") ? this.by(Property.AutomationId, ((String)locator).substring(1)) : this.by(Property.Name, (String)locator);
        IUIAutomationElementArray found = parent.findAll(TreeScope.Descendants, condition);
        return this.toElements(found);
    }

    @Override
    public Element locateInternal(Element root, String locator) {
        IUIAutomationElement parent = (IUIAutomationElement)root.toNative();
        if (PathSearch.isWildcard((String)locator)) {
            locator = "//*{" + (String)locator + "}";
        }
        if (((String)locator).startsWith("/")) {
            if (((String)locator).startsWith("/root")) {
                locator = ((String)locator).substring(5);
                parent = UIA.getRootElement();
            }
            ArrayList<Element> searchResults = new ArrayList<Element>();
            PathSearch search = new PathSearch((String)locator, false);
            this.walkPathAndFind(searchResults, search, UIA.getControlViewWalker(), parent, 0);
            if (searchResults.isEmpty()) {
                return null;
            }
            return (Element)searchResults.get(0);
        }
        IUIAutomationCondition condition = ((String)locator).startsWith("#") ? this.by(Property.AutomationId, ((String)locator).substring(1)) : this.by(Property.Name, (String)locator);
        IUIAutomationElement found = parent.findFirst(TreeScope.Descendants, condition);
        if (!found.isValid()) {
            return null;
        }
        return new WinElement(this, found);
    }

    @Override
    public Element getRoot() {
        return new WinElement(this, UIA.getRootElement());
    }

    @Override
    @AutoDef
    public Element getFocused() {
        return new WinElement(this, UIA.getFocusedElement());
    }

    private void walkPathAndFind(List<Element> searchResults, PathSearch search, IUIAutomationTreeWalker walker, IUIAutomationElement e, int depth) {
        ControlType controlType;
        IUIAutomationCondition condition;
        PathSearch.Chunk chunk = search.chunks.get(depth);
        if (chunk.controlType == null || "*".equals(chunk.controlType)) {
            condition = UIA.getControlViewCondition();
            controlType = null;
        } else {
            controlType = ControlType.fromName(chunk.controlType);
            condition = UIA.createPropertyCondition(Property.ControlType, controlType.value);
        }
        IUIAutomationElementArray array = e.findAll(chunk.anyDepth ? TreeScope.Descendants : TreeScope.Children, condition);
        if (!array.isValid()) {
            return;
        }
        int count = array.getLength();
        boolean leaf = depth == search.chunks.size() - 1;
        for (int i = 0; i < count; ++i) {
            String className;
            String name;
            IUIAutomationElement child;
            if (chunk.index != -1 && chunk.index != i || !(child = array.getElement(i)).isValid() || chunk.nameCondition != null && !chunk.nameCondition.test(name = child.getCurrentName()) || chunk.className != null && !chunk.className.equalsIgnoreCase(className = child.getClassName())) continue;
            if (leaf) {
                searchResults.add(new WinElement(this, child));
                if (search.findAll) continue;
                return;
            }
            this.walkPathAndFind(searchResults, search, walker, child, depth + 1);
        }
    }

    @Override
    public Robot move(int x, int y) {
        super.move(x, y);
        Location loc = this.getLocation();
        WinRobot.moveInternal(-loc.x / 4, -loc.y / 4);
        while (this.getLocation().x < x - 1) {
            WinRobot.moveInternal(1, 0);
        }
        while (this.getLocation().y < y - 1) {
            WinRobot.moveInternal(0, 1);
        }
        return this;
    }

    private static void moveInternal(int x, int y) {
        WinUser.INPUT input = new WinUser.INPUT();
        input.type = new WinDef.DWORD(0L);
        input.input.setType("mi");
        input.input.mi.dx = new WinDef.LONG((long)x);
        input.input.mi.dy = new WinDef.LONG((long)y);
        input.input.mi.time = new WinDef.DWORD(0L);
        input.input.mi.dwExtraInfo = new BaseTSD.ULONG_PTR(0L);
        input.input.mi.dwFlags = new WinDef.DWORD(1L);
        User32.INSTANCE.SendInput(new WinDef.DWORD(1L), new WinUser.INPUT[]{input}, input.size());
    }
}

