/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.query;

import java.util.ArrayList;
import java.util.List;

public class QueryMessage {
    private String sql = null;
    private boolean count = false;
    private List<String> projection = new ArrayList<String>();
    private String entity = null;
    private List<String> whereClause = new ArrayList<String>();
    private Integer startposition = null;
    private Integer maxresults = null;
    private String orderByClause = null;

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public List<String> getProjection() {
        return this.projection;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public List<String> getOptional() {
        return this.whereClause;
    }

    public String toString() {
        if (this.getSQL() == null || this.getEntity() == null) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        query.append(this.sql);
        if (this.isCount()) {
            query.append(" count(*)");
        } else if (this.getProjection().size() == 0) {
            query.append(" ").append("*");
        } else {
            boolean firstProjection = true;
            for (String projectionStr : this.getProjection()) {
                if (firstProjection) {
                    query.append(" ").append(projectionStr);
                    firstProjection = false;
                    continue;
                }
                query.append(", ").append(projectionStr);
            }
        }
        query.append(" FROM ").append(this.getEntity());
        if (this.getOptional() != null) {
            Boolean firstOptional = true;
            for (String optional : this.getOptional()) {
                if (firstOptional.booleanValue()) {
                    query.append(" WHERE ").append(optional);
                    firstOptional = false;
                    continue;
                }
                query.append(" AND ").append(optional);
            }
        }
        if (this.getOrderByClause() != null) {
            query.append(" ORDERBY ").append(this.getOrderByClause());
        }
        if (this.startposition != null) {
            query.append(" STARTPOSITION " + (this.getStartposition() + 1));
        }
        if (this.maxresults != null) {
            query.append(" MAXRESULTS " + this.getMaxresults());
        }
        return query.toString();
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public Integer getStartposition() {
        return this.startposition;
    }

    public void setStartposition(Integer startposition) {
        this.startposition = startposition;
    }

    public Integer getMaxresults() {
        return this.maxresults;
    }

    public void setMaxresults(Integer maxresults) {
        this.maxresults = maxresults;
    }

    public boolean isCount() {
        return this.count;
    }

    public void setCount(boolean count) {
        this.count = count;
    }
}

