/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.intuit.ipp.data.CustomFieldDefinition;
import com.intuit.ipp.data.Fault;
import com.intuit.ipp.data.IntuitEntity;
import com.intuit.ipp.data.ObjectFactory;
import com.intuit.ipp.data.QueryResponse;
import com.intuit.ipp.serialization.CustomFieldDefinitionDeserializer;
import com.intuit.ipp.serialization.IntuitResponseDeserializerHelper;
import com.intuit.ipp.serialization.JsonResourceTypeLocator;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;

public class QueryResponseDeserializer
extends JsonDeserializer<QueryResponse> {
    private IntuitResponseDeserializerHelper intuitResponseDeserializerHelper = new IntuitResponseDeserializerHelper();
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final String FAULT = "Fault";
    private static final String STARTPOSITION = "startPosition";
    private static final String MAXRESULTS = "maxResults";
    private static final String TOTALCOUNT = "totalCount";
    private ObjectFactory objFactory = new ObjectFactory();

    public QueryResponse deserialize(JsonParser jp, DeserializationContext desContext) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationIntrospector primary = new JaxbAnnotationIntrospector();
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)pair);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode jn = (JsonNode)jp.readValueAsTree();
        QueryResponse qr = new QueryResponse();
        Iterator ite = jn.fieldNames();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            if (key.equals(FAULT)) {
                qr.setFault((Fault)mapper.treeToValue((TreeNode)jn.get(FAULT), Fault.class));
                continue;
            }
            if (key.equals(STARTPOSITION)) {
                qr.setStartPosition(Integer.valueOf(jn.get(STARTPOSITION).intValue()));
                continue;
            }
            if (key.equals(MAXRESULTS)) {
                qr.setMaxResults(Integer.valueOf(jn.get(MAXRESULTS).intValue()));
                continue;
            }
            if (key.equals(TOTALCOUNT)) {
                qr.setTotalCount(Integer.valueOf(jn.get(TOTALCOUNT).intValue()));
                continue;
            }
            if (JsonResourceTypeLocator.lookupType(key) == null) continue;
            JsonNode jn1 = jn.get(key);
            LOG.debug("Query response entity Key :" + key);
            if (!jn1.isArray()) continue;
            for (JsonNode jn2 : jn1) {
                this.registerModulesForCustomFieldDef(mapper);
                Object intuitType = mapper.treeToValue((TreeNode)jn2, JsonResourceTypeLocator.lookupType(key));
                if (!(intuitType instanceof IntuitEntity)) continue;
                this.intuitResponseDeserializerHelper.updateBigDecimalScale((IntuitEntity)intuitType);
                JAXBElement intuitObject = this.objFactory.createIntuitObject((IntuitEntity)intuitType);
                qr.getIntuitObject().add(intuitObject);
            }
        }
        return qr;
    }

    private void registerModulesForCustomFieldDef(ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule("CustomFieldDefinition", new Version(1, 0, 0, null));
        simpleModule.addDeserializer(CustomFieldDefinition.class, (JsonDeserializer)new CustomFieldDefinitionDeserializer());
        objectMapper.registerModule((Module)simpleModule);
    }
}

