/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.util;

import com.intuit.ipp.util.Logger;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class PropertyHelper {
    private static final org.slf4j.Logger LOG = Logger.getLogger();
    private static PropertyHelper propertHelper;
    private String version;
    private String requestSource;
    private String requestSourceHeader;

    private PropertyHelper() {
    }

    public static synchronized PropertyHelper getInstance() {
        if (propertHelper == null) {
            return PropertyHelper.init();
        }
        return propertHelper;
    }

    private static PropertyHelper init() {
        propertHelper = new PropertyHelper();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("ippdevkit");
            propertHelper.setVersion(bundle.getString("version"));
            propertHelper.setRequestSource(bundle.getString("request.source"));
            propertHelper.setRequestSourceHeader(bundle.getString("request.source.header"));
        }
        catch (MissingResourceException e) {
            LOG.debug("no value found for key", (Throwable)e);
        }
        return propertHelper;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRequestSource() {
        return this.requestSource;
    }

    public void setRequestSource(String requestSource) {
        this.requestSource = requestSource;
    }

    public String getRequestSourceHeader() {
        return this.requestSourceHeader;
    }

    public void setRequestSourceHeader(String requestSourceHeader) {
        this.requestSourceHeader = requestSourceHeader;
    }
}

