/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.query.expr;

import com.intuit.ipp.query.Operation;
import com.intuit.ipp.query.Path;
import com.intuit.ipp.query.expr.Expression;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarPath
extends Path<Object> {
    public CalendarPath(String path, String entity) {
        super(path, entity);
    }

    private SimpleDateFormat getDateTimeFormatter() {
        SimpleDateFormat formatter = new SimpleDateFormat();
        formatter.applyPattern("yyyy-MM-dd'T'HH:mm:ss");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter;
    }

    private SimpleDateFormat getDateFormatter() {
        SimpleDateFormat formatter = new SimpleDateFormat();
        formatter.applyPattern("yyyy-MM-dd");
        return formatter;
    }

    private String getCalendarAsString(Calendar cal) {
        SimpleDateFormat formatter = this.getDateTimeFormatter();
        Date date = cal.getTime();
        return formatter.format(date).concat("Z");
    }

    public Expression<Calendar> eq(Calendar value) {
        String valueString = "'" + this.getCalendarAsString(value) + "'";
        return new Expression<Calendar>(this, Operation.eq, valueString);
    }

    public Expression<Date> eq(Date value) {
        SimpleDateFormat formatter = this.getDateTimeFormatter();
        String valueString = "'" + formatter.format(value).concat("Z") + "'";
        return new Expression<Date>(this, Operation.eq, valueString);
    }

    public Expression<java.sql.Date> eq(java.sql.Date value) {
        SimpleDateFormat formatter = this.getDateFormatter();
        String valueString = "'" + formatter.format(value) + "'";
        return new Expression<java.sql.Date>(this, Operation.eq, valueString);
    }

    public Expression<Calendar> neq(Calendar value) {
        String valueString = "'" + this.getCalendarAsString(value) + "'";
        return new Expression<Calendar>(this, Operation.neq, valueString);
    }

    public Expression<Date> neq(Date value) {
        SimpleDateFormat formatter = this.getDateTimeFormatter();
        String valueString = "'" + formatter.format(value).concat("Z") + "'";
        return new Expression<Date>(this, Operation.neq, valueString);
    }

    public Expression<java.sql.Date> neq(java.sql.Date value) {
        SimpleDateFormat formatter = this.getDateFormatter();
        String valueString = "'" + formatter.format(value) + "'";
        return new Expression<java.sql.Date>(this, Operation.neq, valueString);
    }

    public Expression<Calendar> lt(Calendar value) {
        String valueString = "'" + this.getCalendarAsString(value) + "'";
        return new Expression<Calendar>(this, Operation.lt, valueString);
    }

    public Expression<Date> lt(Date value) {
        SimpleDateFormat formatter = this.getDateTimeFormatter();
        String valueString = "'" + formatter.format(value).concat("Z") + "'";
        return new Expression<Date>(this, Operation.lt, valueString);
    }

    public Expression<java.sql.Date> lt(java.sql.Date value) {
        SimpleDateFormat formatter = this.getDateFormatter();
        String valueString = "'" + formatter.format(value) + "'";
        return new Expression<java.sql.Date>(this, Operation.lt, valueString);
    }

    public Expression<Calendar> lte(Calendar value) {
        String valueString = "'" + this.getCalendarAsString(value) + "'";
        return new Expression<Calendar>(this, Operation.lte, valueString);
    }

    public Expression<Date> lte(Date value) {
        SimpleDateFormat formatter = this.getDateTimeFormatter();
        String valueString = "'" + formatter.format(value).concat("Z") + "'";
        return new Expression<Date>(this, Operation.lte, valueString);
    }

    public Expression<java.sql.Date> lte(java.sql.Date value) {
        SimpleDateFormat formatter = this.getDateFormatter();
        String valueString = "'" + formatter.format(value) + "'";
        return new Expression<java.sql.Date>(this, Operation.lte, valueString);
    }

    public Expression<Calendar> gt(Calendar value) {
        String valueString = "'" + this.getCalendarAsString(value) + "'";
        return new Expression<Calendar>(this, Operation.gt, valueString);
    }

    public Expression<Date> gt(Date value) {
        SimpleDateFormat formatter = this.getDateTimeFormatter();
        String valueString = "'" + formatter.format(value).concat("Z") + "'";
        return new Expression<Date>(this, Operation.gt, valueString);
    }

    public Expression<java.sql.Date> gt(java.sql.Date value) {
        SimpleDateFormat formatter = this.getDateFormatter();
        String valueString = "'" + formatter.format(value) + "'";
        return new Expression<java.sql.Date>(this, Operation.gt, valueString);
    }

    public Expression<Calendar> gte(Calendar value) {
        String valueString = "'" + this.getCalendarAsString(value) + "'";
        return new Expression<Calendar>(this, Operation.gte, valueString);
    }

    public Expression<Date> gte(Date value) {
        SimpleDateFormat formatter = this.getDateTimeFormatter();
        String valueString = "'" + formatter.format(value).concat("Z") + "'";
        return new Expression<Date>(this, Operation.gte, valueString);
    }

    public Expression<java.sql.Date> gte(java.sql.Date value) {
        SimpleDateFormat formatter = this.getDateFormatter();
        String valueString = "'" + formatter.format(value) + "'";
        return new Expression<java.sql.Date>(this, Operation.gte, valueString);
    }

    public Expression<Calendar> in(Calendar[] value) {
        String valueString = "";
        Boolean firstCalendar = true;
        for (Calendar v : value) {
            if (firstCalendar.booleanValue()) {
                valueString = valueString.concat("('").concat(this.getCalendarAsString(v)).concat("'");
                firstCalendar = false;
                continue;
            }
            valueString = valueString.concat(", '").concat(this.getCalendarAsString(v)).concat("'");
        }
        valueString = valueString.concat(")");
        return new Expression<Calendar>(this, Operation.in, valueString);
    }

    public Expression<Date> in(Date[] value) {
        SimpleDateFormat formatter = this.getDateTimeFormatter();
        String valueString = "";
        Boolean firstCalendar = true;
        for (Date v : value) {
            if (firstCalendar.booleanValue()) {
                valueString = valueString.concat("('").concat(formatter.format(v).concat("Z")).concat("'");
                firstCalendar = false;
                continue;
            }
            valueString = valueString.concat(", '").concat(formatter.format(v).concat("Z")).concat("'");
        }
        valueString = valueString.concat(")");
        return new Expression<Date>(this, Operation.in, valueString);
    }

    public Expression<java.sql.Date> in(java.sql.Date[] value) {
        SimpleDateFormat formatter = this.getDateFormatter();
        String valueString = "";
        Boolean firstCalendar = true;
        for (java.sql.Date v : value) {
            if (firstCalendar.booleanValue()) {
                valueString = valueString.concat("('").concat(formatter.format(v)).concat("'");
                firstCalendar = false;
                continue;
            }
            valueString = valueString.concat(", '").concat(formatter.format(v)).concat("'");
        }
        valueString = valueString.concat(")");
        return new Expression<java.sql.Date>(this, Operation.in, valueString);
    }

    public Expression<Calendar> between(Calendar startValue, Calendar endValue) {
        String valueString = "'" + this.getCalendarAsString(startValue).concat("Z") + "' AND '" + this.getCalendarAsString(endValue) + "'";
        return new Expression<Calendar>(this, Operation.between, valueString);
    }

    public Expression<Date> between(Date startValue, Date endValue) {
        SimpleDateFormat formatter = this.getDateTimeFormatter();
        String valueString = "'" + formatter.format(startValue).concat("Z") + "' AND '" + formatter.format(endValue) + "'";
        return new Expression<Date>(this, Operation.between, valueString);
    }

    public Expression<java.sql.Date> between(java.sql.Date startValue, java.sql.Date endValue) {
        SimpleDateFormat formatter = this.getDateFormatter();
        String valueString = "'" + formatter.format(startValue).concat("Z") + "' AND '" + formatter.format(endValue) + "'";
        return new Expression<java.sql.Date>(this, Operation.between, valueString);
    }
}

