/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.security;

import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.security.IAuthorizer;
import java.net.HttpURLConnection;
import org.apache.http.client.methods.HttpRequestBase;

public class OAuth2Authorizer
implements IAuthorizer {
    private String accessToken;

    @Override
    public void authorize(HttpRequestBase httpRequest) throws FMSException {
        httpRequest.setHeader("Authorization", "Bearer " + this.accessToken);
    }

    @Override
    public void authorize(HttpURLConnection httpUrlConnection) throws FMSException {
        httpUrlConnection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
    }

    public OAuth2Authorizer(String accessToken) {
        this.accessToken = OAuth2Authorizer.trim(accessToken);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    private static String trim(String key) {
        if (key == null) {
            return null;
        }
        return key.trim();
    }
}

