/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import com.intuit.ipp.data.Attachable;
import com.intuit.ipp.data.AttachableResponse;
import com.intuit.ipp.data.Fault;
import java.io.IOException;
import java.util.Iterator;

public class AttachableResponseDeserializer
extends JsonDeserializer<AttachableResponse> {
    private static final String FAULT = "Fault";
    private static final String ATTACHABLE = "Attachable";

    public AttachableResponse deserialize(JsonParser jp, DeserializationContext desContext) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JakartaXmlBindAnnotationIntrospector primary = new JakartaXmlBindAnnotationIntrospector();
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)pair);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode jn = (JsonNode)jp.readValueAsTree();
        AttachableResponse qr = new AttachableResponse();
        Iterator ite = jn.fieldNames();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            if (key.equalsIgnoreCase(FAULT)) {
                qr.setFault((Fault)mapper.treeToValue((TreeNode)jn.get(FAULT), Fault.class));
                continue;
            }
            if (!key.equalsIgnoreCase(ATTACHABLE)) continue;
            qr.setAttachable((Attachable)mapper.treeToValue((TreeNode)jn.get(ATTACHABLE), Attachable.class));
        }
        return qr;
    }
}

