/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import com.intuit.ipp.data.CDCResponse;
import com.intuit.ipp.data.Fault;
import com.intuit.ipp.data.QueryResponse;
import com.intuit.ipp.serialization.QueryResponseDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;

public class CDCQueryResponseDeserializer
extends JsonDeserializer<CDCResponse> {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final String FAULT = "Fault";
    private static final String SIZE = "size";
    private static final String QUERY_RESPONSE = "QueryResponse";

    public CDCResponse deserialize(JsonParser jp, DeserializationContext desContext) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JakartaXmlBindAnnotationIntrospector primary = new JakartaXmlBindAnnotationIntrospector();
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)pair);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode jn = (JsonNode)jp.readValueAsTree();
        CDCResponse qr = new CDCResponse();
        Iterator ite = jn.fieldNames();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            if (key.equals(FAULT)) {
                qr.setFault((Fault)mapper.treeToValue((TreeNode)jn.get(FAULT), Fault.class));
                continue;
            }
            if (key.equals(SIZE)) {
                qr.setSize(Integer.valueOf(jn.get(SIZE).intValue()));
                continue;
            }
            if (key.equals(QUERY_RESPONSE)) {
                JsonNode jn1 = jn.get(key);
                if (!jn1.isArray()) continue;
                ArrayList<QueryResponse> queryResponses = new ArrayList<QueryResponse>();
                for (JsonNode jn2 : jn1) {
                    QueryResponse queryResponse = this.getQueryResponse(jn2);
                    queryResponses.add(queryResponse);
                }
                qr.setQueryResponse(queryResponses);
                continue;
            }
            LOG.warn("Unknown key for CDCResponse :" + key);
        }
        return qr;
    }

    private QueryResponse getQueryResponse(JsonNode jsonNode) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule("QueryResponseDeserializer", new Version(1, 0, 0, null));
        simpleModule.addDeserializer(QueryResponse.class, (JsonDeserializer)new QueryResponseDeserializer());
        mapper.registerModule((Module)simpleModule);
        return (QueryResponse)mapper.treeToValue((TreeNode)jsonNode, QueryResponse.class);
    }
}

