/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import com.intuit.ipp.data.CustomField;
import com.intuit.ipp.data.CustomFieldDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;

public class CustomFieldDefinitionDeserializer
extends JsonDeserializer<CustomFieldDefinition> {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final String CUSTOM_FIELD = "CustomField";
    private static final String TYPE = "Type";

    public CustomFieldDefinition deserialize(JsonParser jp, DeserializationContext desContext) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JakartaXmlBindAnnotationIntrospector primary = new JakartaXmlBindAnnotationIntrospector();
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)pair);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode jn = (JsonNode)jp.readValueAsTree();
        CustomFieldDefinition qr = null;
        Iterator ite = jn.fieldNames();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            if (!key.equals(CUSTOM_FIELD)) continue;
            JsonNode jn1 = jn.get(key);
            qr = this.getCustomFieldDefinitionType(jn1);
            LOG.debug("The CustomFieldDefinition implementation type " + qr);
            if (qr == null) continue;
            ArrayList<CustomField> customFields = new ArrayList<CustomField>();
            for (JsonNode jn2 : jn1) {
                customFields.add((CustomField)mapper.treeToValue((TreeNode)jn2, CustomField.class));
            }
            qr.setCustomField(customFields);
            return qr;
        }
        return null;
    }

    private CustomFieldDefinition getCustomFieldDefinitionType(JsonNode jn) throws IOException {
        if (jn.isArray()) {
            JsonNode jn1 = jn.get(0);
            String type = jn1.get(TYPE).textValue();
            try {
                return (CustomFieldDefinition)Class.forName("com.intuit.ipp.data." + type + "CustomFieldDefinition").newInstance();
            }
            catch (Exception e) {
                throw new IOException("Exception while deserializing CustomFieldDefinition", e);
            }
        }
        return null;
    }
}

